For the last three years, law firm Perkins Coie, the XR Association, and Boost VC have conducted a survey on industry attitudes toward AR and VR technology.
Here, we look at some of the major trends in the survey. We also look at how they compare to similar recent studies in the AR and VR world.
Before we jump into the survey results, there are a couple of things to understand going in.
First, while this study is being released in what is (hopefully) the height of the COVID-19 panic, the results were collected before the outbreak. So, while social distancing and remote work has definitely increased the buzz around AR and VR technology, it didn’t drive the results in this report.
“Of note, the Fourth Annual AR/VR Survey was conducted at the outset of the coronavirus outbreak, before the pandemic gripped the global community,” read a press release shared with ARPost by Perkins Coie.
Second, the survey primarily reflects the views of industry and enterprise – not entertainment. This is the case with a number of these surveys for a number of reasons. One reason is that the needs, hopes, and fears of industry are different than those of entertainment. The other is that the markets are completely different and looking at entertainment washes out everything else.
Plummeting hardware and software costs, increasingly impactful applications outside of entertainment, and the ubiquity of mobile devices are contributing to the rise of immersive XR technologies..
Major Trends
Coming in at 33 pages, we won’t cover everything that the survey found. It’s linked above if you want to take the plunge for yourself, but we’ll unpack a couple of key findings.
Increasing Adoption
Perhaps the biggest takeaway of the whole report was confidence in increasing adoption of AR and VR in industry.
“Plummeting hardware and software costs, increasingly impactful applications outside of entertainment, and the ubiquity of mobile devices are contributing to the rise of immersive XR technologies,” reads the report’s executive summary.
One key reason for this increased adoption, in addition to technological factors, are socio-economic factors. The report specifically mentions “smart cities.”
“Smart cities are generally defined as places where new technologies like cloud computing, advanced analytics, and blockchain are deployed to improve the delivery of services and quality of life,” is stated in the report.. “Increasingly, immersive technologies are becoming a part of the urban landscape in many of these pioneering municipalities around the world.”
Similarly, excitement over the advent of 5G internet is reportedly driving increased excitement over AR and VR technology.
Diversified Monetization
Monetization of AR and VR experiences needs to do two things. It needs to allow the producer to pay off and profit from the experience. It also needs to make the experience affordable and usable for users.
According to the study, producers are looking for – and finding – new ways of monetizing their experiences. These include offering subscriptions, product placement and advertisements, and in-app purchases. Incidence of all of these methods are increasingly being used from last year.
The topic of allowing in-app purchases was a significant topic of discussion during Facebook’s Game Developer’s Showcase earlier this month.
AR Over VR?
Any casual XR users still may or may not be surprised to hear that three-fourths of respondents said that they expect AR to pass VR in revenue in the future.
In entertainment, VR is often the flashier, more exciting technology. However, with phone-compatible AR experiences and their ability to enhance data visualization and real-world environments, AR is often more exciting to industry and enterprise.
Disruption in Healthcare
Respondents to the survey found healthcare to be the field most “ripe for disruption” – after entertainment, naturally.
That shouldn’t be surprising. Immerse UK’s study similarly identified healthcare as one of their top “potential growth areas” for AR and VR technology.
Increased Spending
Another two-thirds of respondents said that they expect spending by businesses on AR and VR technology to be higher in 2020.
This is an exciting and nuanced result. This survey and the Immerse UK survey both found funding to be a barrier to larger adoption.
Nearly half of respondents (46%) said that “lack of established market for the technology” is potential investors’ most common concern.
Data Security
Another persistent barrier identified in the report involved concerns regarding data security. This is a particularly large issue when it comes to healthcare. Both the study by Immerse UK and a late 2019 report by Mojo Vision identified similar concerns.
Many VR applications and all AR applications require the use of a device’s camera. Any time that a camera and the internet are required for an application, there are potential security concerns. This is doubly true with many AR applications relying on the cloud to reduce memory requirements and increase computing power.
While this study did identify data security as a sticky concern, they also identified that those concerns were down among respondents.
“In the 2019 survey, 61% of respondents cited consumer privacy and data security as the top legal risks for developing immersive technology applications and content,” read the release from Perkins Cloi. “This year, that percentage dropped to 49%, which likely stems from companies’ decisions to proactively address and update privacy policies and disclosures regarding consumer data.”
Takeaways
This survey, and every other industry survey we’ve come across, have agreed that AR and VR technology has a growing place in the workforce. Particularly, healthcare (yes, and entertainment) have an affinity for these technologies.
However, there are still some obstacles. While data privacy may be sorting itself out, establishing markets takes time in any new industry.
About the Survey
The survey was sent to nearly 200 XR professionals including established tech firms, startups, and investors.
Perkins Coie is an international law firm specializing in commercial litigation, intellectual property, and regulatory legal advice.
The XR Association represents AR and VR technology manufacturers.
Boost VC is a venture capital accelerator that works with emerging technology startups.