"Willem,” our guide Matthew Laizer at the Singita Grumeti game reserve whispered, while closing his hand as if to pull taffy. My eight-year-old son responded instantly by sitting down and quieting his twitchy limbs. We had discovered early in our nine-day journey from the Serengeti Plains in Tanzania to the Maasai Mara in Kenya that a guide gauges an animal’s receptivity to close observation through near imperceptible clues—a depression in the grass, a confrontational gaze. And with much the same acuity, we had begun to decode the nuances of our guide’s expression, pace, and hand gestures.
“I didn’t like the way he was looking at Willem,” Laizer explained. Willem had stood up suddenly to take a photo, catching a young male lion’s attention—and, it seems, disrupting an unspoken covenant of safari protocol. In the days before, we had come close enough to touch prides of 14 and 20 lions varying in age, gender, and state of hunger throughout Singita’s pristine 350,000-acre concession without inciting even the flick of an ear. This particular “teen,” according to Laizer, might have mistaken Willem for a baby wildebeest. “I feel this lion has a bit of an attitude,” he said matter-of-factly. “Even the lioness in the same pride doesn’t trust him with her littlest cubs. See how she keeps turning around?” The animals, accustomed to being observed, view the vehicle and its passengers as a single entity. Once humans exceed its fragile perimeter, they, like any other moving mammal, become recognizable as prey. (Not surprisingly, when I looked back at Willem, he had moved to the center seat, where he would sit on his hands for the remainder of the drive.)
We had arranged to go on safari with another family over our sons’ spring break. I wish I could say that I had planned the entire itinerary by trolling blogs and social feeds and cobbling together tidbits from my most well-traveled friends, as I have for so many other trips in my life. Or that it was easy for me to relinquish control to an expert. But the truth is, there are some trips that we simply can’t—or shouldn’t—plan on our own, and a safari is one of them. Especially with an eight-year-old in tow. Thankfully, Cherri Briggs of Explore has relationships with local operators and governments and deep knowledge of this part of East Africa. She made our nine-day, two-country, five-lodge, three-charter-flight adventure not only possible but seamless. (The only thing she blanched at was that our vacation wasn’t longer.) Briggs was one of the few people I spoke with who didn’t think eight was too young for this kind of trip.
There are obvious reasons for taking your child to East Africa (total nature immersion; exposure to a wildly different culture), but it is the unscripted life lessons that linger. Feeling the sting of insignificance—rare in this age of narcissism—while observing the migration of 1.5 million wildebeests. Digesting the necessary cruelty of the hyena kill. Making sense of the near inconsolable sadness you feel after spending a carefree afternoon playing soccer with kids your own age in a local school, and realizing that most of them were running around shoeless. Instilling unteachable virtues, such as patience, that aren’t really a choice but rather the price of admission for this level of proximity to wild animals. Up before dawn and still roaming after dark, we logged 12 hours a day in trucks, at times waiting long stretches for a mother cheetah to signal to her two cubs that the coast was clear and that it was safe for them to eat. Rather than fill the void with social media’s continuous self-reference, children and adults alike sat still without the repeat validation of the smartphone swipe.
At &Beyond’s Serengeti Under Canvas, a dreamy semi-permanent tented camp in Serengeti National Park that moves with the migratory herds, we were lucky enough to spend our first two days with an expert wildlife guide, Anthony Kivuyo, and the company’s regional director, Niall Anderson. Both are passionate birders, and showed us how to track and identify birds with names like blacksmith lapwing and yellow-throated sandgrouse, and in so doing helped deemphasize the primacy of the Big Five. I came to feel that a great guide is like the coach who convinces your kid that defense is as important as offense, that it’s not just about the big cats but about the hundreds of plumed species which require careful observation. (My son, months after our trip, still draws pictures of the secretary bird and the superb starling alongside an elephant, and all, I might add, at the same scale.)
But it’s the four-inch keloid scar on the back of our guide Laizer’s neck that Willem still tells his friends about. A Maasai warrior turned guide and conservationist, Laizer filled some of the wait time (we watched a young bumbling male cheetah, still under his mother’s tutelage, try to track a Thomson’s gazelle) with the details of his life. In this case, he described a botched lion slaying when he was 15, at the time a boy’s rite of passage in the Maasai tradition, as well as his ongoing campaign to help educate the girls in his community and protect them against genital mutilation. Laizer’s dual citizenship within Western and Maasai cultures, a constant wrestling between modernity and tradition, was fodder for much discussion. Once, returning home after a long stretch at Singita, he was physically—and embarrassingly—unable to swallow his father’s traditional cow’s blood offering. My son still asks me, “How many days does it take Matthew to get to his village from Singita?” Three. Almost a full day on a bus, followed by two days on foot, traversing the wild so he can visit with relatives along the way.
On our last night, as I lay awake in the dark with my son in our airy canvas tent at Mara Plains Camp, sited on a densely forested bend in a river in the Olare Motorogi Conservancy, I thought about all we’d packed into just over a week, thanks in no small part to easy plane transfers and expert planning. With grunting hippos and hissing cats providing a soundtrack by turns lulling and haunting, I realized that true adventure lies in that butterfly-bellied dream state where beauty and just-outside-your-comfort-zone fear intersect.
Ready to get going? For more details about the extraordinary trips travel specialists like these have planned, a full breakdown of their areas of expertise, and contact info head to our Travel Specialist guide.