Homicide detectives and special agents have a lot in common.
Justin Sullivan/Getty Images News/Getty Images
Homicide detectives across the U.S. had more than 15,000 new murder cases to solve in 2009, according to the Federal Bureau of Investigation. Criminal investigators may work on murder cases, but usually have felonies on their to-solve lists. In fact, of the 35,840 criminal investigators employed by the federal government in 2009, 58 percent were special agents with Department of Justice agencies: the FBI, the Drug Enforcement Administration and the Bureau of Alcohol, Tobacco, Firearms and Explosives.
Detective Training
The road leading to employment as a homicide detective begins with becoming a police officer, and according to the All Criminal Justice Schools website, at least three years of patrol duty. The minimum requirements for police officers -- high school diploma or GED and police academy training -- vary by department. Some prefer candidates who have studied criminal justice and speak a second language. Gaining a solid foundation in the basics of criminal justice through a bachelor's degree can lead to faster promotions. Aspiring detectives with their eyes on the top departmental ranks should earn a master's degree.
Investigator Training
Private investigation, law enforcement, security and military experience can substitute for education for aspiring criminal investigators. However, candidates become more competitive with a four-year degree in forensics, criminal justice, sociology or psychology. A master's degree increases promotion potential, while cybercrime, financial crime and forensics work demands additional coursework for expertise. Assignments with state police departments and agencies also require successful completion of training at a state or regional academy. Federally employed crime investigators usually attend the Georgia-based Federal Law Enforcement Training Center.
Duties
These two professions work on different types of crime, but perform similar duties. They gather information through face-to-face interviews. Both keep detailed records of their investigations and work with other law enforcement professionals in the course of solving a crime. They observe suspects and handle warrants. They share a responsibility to testify in court and the authority to make arrests. Homicide detectives, as part of a murder investigation team, work closely with crime scene investigators, the coroner and the district attorney. According to the San Jose Police Department, one of the most important aspects to being a homicide detective is the ability to persuade witnesses to testify in court. Criminal investigators work on cases involving terrorism, fraud, smuggling, money laundering, kidnapping and immigration, depending on their expertise. They collaborate with local law enforcement, federal and state agencies and prosecutors at all levels of government.
Career Paths – Homicide Detective
The larger the organization, the more opportunities homicide detectives have for advancement. In the New York Police Department, the largest in the country, detectives can move up the ranks as detective grade 2 and detective grade 3. Every two to three years, the department offers exams for promotions to sergeant, lieutenant and captain, each with grade levels. According to retired NYPD detective Michael D. Sapraicone, only 15 to 20 detectives are assigned to each homicide squad, and is considered the most prestigious assignment.
Career Paths – Criminal Investigator
Criminal investigators have a broader career path than homicide detectives because of the variety of employers who need their services. Within any of the country's state police departments, criminal investigators have opportunities to rise through the ranks within a division to regional commander and above. Alternatively, states like Virginia, offer law enforcement career tracks in areas such as security services and public safety compliance, each with levels of advancement. Criminal investigators also have the option of private sector employment with financial institutions, insurance companies, retail operations, colleges and legal firms, or even in private practice. According to the Bureau of Labor Statistics, most states have license requirements for private investigators. Those employed by federal agencies can advance through six grade levels within the federal pay scale: from GS-7 to GS-14.
References (10)
- U.S. Census Bureau: Law Enforcement, Courts, & Prisons; Crimes and Crime Rates by Type of Offense
- BrainTrack.com: Career and School Info for Detectives and Criminal Investigators
- Federal Jobs.net: Law Enforcement Hiring Agencies; Law Enforcement Employment Occupations
- All Criminal Justice Schools: Homicide Detective Careers
- U.S. Department of Labor: Bureau of Labor Statistics; Police and Detectives; How to Become
- DiplomaGuide.com: Becoming a Homicide Detective Job Description & Salary Info
- Criminal Investigator HQ: Differences Between Detectives and Criminal Investigators
- Legal-Criminal-Justice Schools: How to Become a Criminal Investigator
- San Jose Police Department: Behind the Scenes of an Investigation
- U.S. Department of Labor: Bureau of Labor Statistics; Police and Detectives; What They Do
Resources (10)
- U.S. Office of Personnel Management: Administrative Work -- Inspection, Investigation, Enforcement & Compliance
- New York Police Department: Promotional Opportunities; Detective
- The New York Times: City Room; Answers About Investigating Homicides Part 2
- Criminal Investigator HQ: What Is a Federal Criminal Investigator?
- State of Arkansas: Criminal Investigations Division
- State of Oregon: Criminal Investigations Division
- Commonwealth of Pennsylvania: Pennsylvania State Police; Station Directory; Troop A
- Commonwealth of Virginia: Career Guide for Detectives and Criminal Investigators
- U.S. Department of Labor: Bureau of Labor Statistics; Private Detectives and Investigators; How to Become
- CityTownInfo.com: Criminal Investigators - Schools and Careers
Photo Credits
- Justin Sullivan/Getty Images News/Getty Images