Nest has appointed Octopus Renewables to boost its investment in clean energy infrastructure, with £250m expected to be committed this year in the UK and Europe, as part of a potential £1.4bn investment by the end of the decade.
By investing directly in green energy generation, Nest stated that it will secure “stable, long-term returns” for pension savers, whilst also achieving its ambition of becoming a net-zero carbon investor.
The mandate will target deployment into renewable energy projects and the associated infrastructure, predominantly in the UK and Europe, to support the transition to a net-zero economy.
As part of this, Octopus Renewables will arrange investment deals directly with the owners of renewable infrastructure projects, negotiating bespoke deals to ensure members are "suitably rewarded" for injecting new funding.
The scheme emphasised that most people want their pension to address climate change, citing recent research, undertaken by YouGov, which found that 65 per cent of pension savers believe their pensions should be invested in a way that reduces the impact of climate risk, compared to 4 per cent strongly disagreed.
Furthermore, 79 per cent believe it's important that the economic recovery post-Covid takes climate change into account, while a further 57 per cent are worried about the impact of climate change on their lives.
Nest chief investment officer, Mark Fawcett, highlighted investing in renewable infrastructure as a “win-win for all involved”, emphasising that the “strong foundations” of this kind of investment should help achieve “great returns” whilst also directly investing in the future of the planet.
He stated: “We want to invest in the energy of the future, not the past. The money we manage on behalf of our members needs to provide steady returns for the next 10, 20, 30 years.
“Renewable energy projects are fantastic opportunities. Every new site provides greater energy security, increases potential returns and contributes to tackling the climate emergency. We want to deliver bigger pensions for our members, in a better world.
“All minds are focused on how to help build back better from the pandemic and this move means millions of UK pension savers will be playing their part.
“Investing in British green energy means our members will be investing in projects they can see and touch, a tangible connection to their pension and a way out of the climate crisis.”
Adding to this, Octopus Renewables co-head, Alex Brierley, described the appointment as a “milestone moment”.
He stated: “With predictable income, diversification and sustainable investment all at the forefront of institutional investors’ minds, renewable energy is an incredibly attractive asset class, for which demand is growing at pace.
“This partnership will create a strong platform for Nest, covering a diverse range of technologies, geographies and assets across their lifecycle, whether that be at development, construction or operational stages.
"The fund will also allocate capital to growth opportunities in the wider energy transition.”
The announcement has also been welcomed by Pensions Minister, Guy Opperman, who commented: “I welcome the decision by Nest to expand into innovative and green markets, and this should encourage other schemes to make the same leap.
“Nest’s action shows that schemes with economies of scale can access alternative investments, including renewable technologies, at a low cost to their members.”
This was echoed by campaign group, Make My Money Matter, with CEO, Tony Burdon, highlighting the move as a “substantial investment in clean energy solutions” and a “powerful example of how our pensions can be a force for good".
“This move also addresses the financial risk associated with continuing to invest in oil and gas, shifting investment into the new and greener commercial opportunities of the future,” he added.
“Ahead of Cop26, we call on all major UK pension schemes to follow Nest's lead by committing to net zero and by growing their green investment portfolio. ”
Industry research has previously suggested that pension schemes expect an increase in renewable energy investments as divestment from fossil fuels slowed amid the pandemic.
However, the partnership will also give Nest full access to Octopus Renewables' proprietary deal-flow, across technologies and geography, which Nest head of private markets, Stephen O'Neill stated had given the scheme confidence that the investment will provide strong returns for members.
Commenting more broadly, O'Neill argued that private markets are no longer exclusively for defined benefit pension schemes, and will play an important role in Nest's portfolio, helping to buoy performance when public markets, particularly equities, are struggling.
“We are supportive of government initiatives that will help smooth the way for schemes to access the long-term return potential in private markets at the right price for auto-enrolled members," he added.
“We hope to be among the first of many defined contribution pension schemes to offer members the diversification and return benefits available beyond equity and bond markets."
Indeed, the government recently announced plans to remove the "barriers" in pension regulation that might discourage DC pension schemes from investing in certain assets, with industry experts also calling for more access to private market investments.
Nest is also currently considering appointing further fund managers to help provide greater access to unlisted infrastructure equity, estimating that infrastructure equity projects will represent around 5 per cent of the total portfolio "within a few years".
This is estimated to take Nest's investment in private markets up to around 15 per cent, which is anticipated to be £13bn in Nest's portfolio by 2030.
Nest to invest £1.4bn in green energy in UK and Europe
Nest has appointed Octopus Renewables to boost its investment in clean energy infrastructure, with £250m expected to be committed this year in the UK and Europe, as part of a potential £1.4bn investment by the end of the decade.
Recent Stories