Depression FAQs
What is depression?
Depression is a prolonged or deep emotional sensation of sadness, being "blue", or "down." Depressive feelings such as discouragement or sadness are perfectly normal if they do not become too severe or last too long. Depression becomes a clinical problem if a person’s mood becomes too depressed or if the episode lasts more than two weeks. If there is any question about the severity of a person’s depression, he/she should have an immediate evaluation by a mental health professional or a physician in order to rule out suicidal intent.
What characteristics are associated with depression?
Depression includes some of the following characteristics:
- Feeling sad, blue, or down
- Feeling unworthy
- Feeling guilty
- Feeling helpless
- Loss of energy
- Feeling restless
- Feeling irritable
- Feeling lethargic
- Fatigue
- Increased sleep or decreased sleep
- Insomnia or awakening during the night
- Awakening earlier or later than normal
- Loss of interest in hobbies, activities
- Loss of interest in sex
- Decreased ability to concentrate
- Decreased ability to remember
- Increase or decrease of appetite
- Increase or decrease in weight
- Thoughts of death
- Thoughts of suicide
Also, physical symptoms such as chronic pain or a lingering illness can sometimes signal a depression.
Similar to other illnesses, such as heart problems, asthma, or diabetes, depression can become severe and disabling.
Are there genetic factors associated with depression?
Depression tends to occur in families. If someone is depressed, it is at least twice as likely that a close relative has had or will have depression. Also, it is common to find such problems as substance abuse or attention-deficit/hyperactive disorder in the close relatives of depressed people.
Does depression affect males, females, or both?
Anyone, male or female, can get depressed. However, in the United States , women become depressed about twice as often as men.
At what age does depression appear?
Depression can strike a person at any age. Even small children can become depressed if they experience a serious loss such as the death of a parent. (Read more about Childhood Depression.)
Depression is quite common in adolescence and adulthood. Also, it is not unusual to find depression in the geriatric population where loss is so evident.
How often is depression seen in our society?
Depression is very prevalent in our society. Today, more than 10 million Americans are being treated for depression.
How is depression diagnosed?
A mental health professional arrives at the diagnosis of depression by taking a careful, personal history from the client/patient. The personal history consists of the recent events associated with the depressed mood, a past history, and a family history. The client/patient may be asked to complete a mood inventory or depression questionnaire. There are no laboratory tests necessary to diagnose depression nor are there any physical conditions that must be met. However, it is very important not to overlook a physical illness that might mimic or contribute to depression. If there is any possibility that the client/patient may have a physical problem, the mental health professional should recommend a complete physical examination by a medical doctor. It is not uncommon for people with depression to have symptoms of physical illness. Many physicians make the diagnosis of depression while attempting to find the cause of a patient’s headache, fatigue, sleep, or other physical problems.
Depression may follow a significant personal loss. For instance, the loss of a loved one, the loss of a job, or a move to a new location may trigger a depressed mood. Some depression is caused by a chemical imbalance in the brain. The chemical imbalances associated with depression resemble chemical imbalances in the body that are associated with other common diseases such as diabetes.
How is depression treated?
Although some depression may go away on its own, people with depression can often be greatly helped with treatment. The treatment for depression consists of psychotherapy, medication, or both. A friend or family member who encourages the depressed person to seek professional help may be a lifesaver. Many people cannot lift themselves out of their depression alone. They need the care and empathy of friends and family, and many benefit from the help of a mental health professional.
Most depression is treated in an outpatient setting. However, seriously depressed people who have thoughts of suicide must be considered for immediate hospitalization. Suicidal thoughts should always be taken seriously as suicide is the eighth leading cause of death in the United States ; it is the second leading cause of death in adolescents. More than seventy (70) people die from suicide every day in the United States . More than 40,000 people die annually in the U.S. From suicide.
Many people with depression are relieved after their initial session of therapy. Knowing that someone understands and that there is a professional who can help is an enormous relief to many who suffer from depression. However, it generally takes at least a couple of weeks after beginning therapy before people begin to feel better.
The treatment of depression can sometimes be enhanced with the use of prescribed medications called Anti-Depressants. If medications are prescribed, it usually takes ten to fourteen (10 - 14) days before most people begin to appreciate the benefit of the antidepressants.
What happens to someone with depression?
The course of depression is quite variable. Some people will experience only one significant depressive episode for which they receive treatment, and they may never have another episode. Other people may have recurrent bouts of depression that require intermittent treatment throughout their lives. Still others suffer from chronic depression and have to remain in therapy and/or on medication for many years.