Severe and Resistant Infections
We live in world where bacteria are becoming resistant to antibiotics. We can expect this scenario to get worse as even though antibiotic use has gone down in general practice, vast amounts of antibiotics indiscriminately in factory farming and few new antibiotics have been invented. We need to have as many methods as possible to deal with this new threat.
These remedies could save your life (for instance in a new virulent flu epidemic).
Vitamin C
High dose Vitamin C is one of the best ways to deal with serious infections. It needs to be built up to bowel tolerance. This is the dose that gives slightly loose stools and is usually 10-15 grams daily. To be effective the Vitamin C needs to be at 80-90% of bowel tolerance. The easiest form to use is Vitamin C powder dissolved in warm water (see Vitamin C leaflet for full details).
Marik published evidence in 2017 that patients with sepsis in Intensive Care Units given intravenous Vitamin C, thiamine (vitamin B1) and hydrocortisone had a nearly five-fold better survival rate (40.4% compared to 8.5% having standard treatment)1. He then treated a further 150 patients with a 1% mortality (normal for sepsis 30-50%). Dr Klenner has demonstrated vitamin C infusions are effective against a wide variety of viruses including influenza, herpes, polio and hepatitis. Why intravenous Vitamin C isn’t used as a standard therapy for sepsis in hospitals is hard to comprehend.
Iodine
Iodine kills bacteria, viruses, fungi and all known pathogens with no resistance. It is very safe. For acute infections use Lugol’s iodine 12.5% (available from Amazon). The dose is 2 drops in a glass of water every hour until symptoms are easier. (French physician Lugol who developed Lugol’s iodine in 1829 used up 160 drops daily with good results in infections. With long-term high use monitor thyroid function.
Herbal Remedies
Herbalist Harold Gaier needed surgery for a complex displaced fracture of his foot. The surgery went fine but his recovery was complicated by a multidrug-resistant MRSA infection. Antibiotics failed to help him. He had to smuggle two herbal tinctures into the hospital: Goldenseal (hydrastis canadensis) and Barberry (berberis vulgaris). He alternated them, taking 15mls four times daily of one then switching to the same dose of the other the next day. He made a complete recovery in three weeks. Unfortunately he needed further surgery, again complicated by MRSA and again unresponsive to antibiotics. He treated himself a second time with full recovery. He has used this combination successfully in many of his patients with complex infections.
Thymus Extract
Dr Burgstiner, past president of the Medical Association of Georgia and an obstetrician and gynaecologist, developed Hepatitis B after puncturing his finger during an operation. Seven years later he was still ill and unable to practice surgery.
While searching for answers he recalled the principle of using glandular extracts for under-functioning glands such as the thyroid and pancreas. If your thyroid dries up you give thyroxine, if your pancreas dries up you give insulin. He reasoned that as the immune system depends on the thymus gland that taking thymus extract would help.
Dr Burgstiner purchased some thymus extract and a vitamin-mineral complex from his local health food store and began taking them. Six weeks later his blood test for hepatitis was negative. An independent laboratory found these supplements gave a 700% increase in immune system activity. He later found that thymic extract without the vitamin-mineral complex did not have the same effect. He then went on to fine tune his treatment, eventually producing Thymic Formula. He found it arrested many cases of Hepatitis B and C, multiple sclerosis, rheumatoid arthritis and helped with systemic lupus and psoriasis. Thymic extracts usually give a significant improvement within one month.
Ketogenic Diet
Microbes need sugar to survive. Vitamin C and sugar also compete for absorption in bacteria. Sugar can double the number of bacteria within 20 minutes. Sugar and refined carbohydrate (white flour, bread, pasta, white rice, cereals) need to be completely eliminated whilst fighting an infection. This diet effectively starves the microbes out by removing their food. This is a tough diet but can make a real difference in the common scenario where an infection is failing to respond to standard treatment.
- Marik PE, Khangoora VK, Rivera R et al. Hydrocortisone, Vitamin C and Thiamine for the treatment of Severe Septic Shock: A retrospective Before-After Study. Chest, 2017; 151(6):1229-38