.
In selecting compliant companions instead of more aggressive members of the same species, humans may have inadvertently picked animals with mild neural crest cell defects, say geneticist Adam Wilkins of Humboldt University of Berlin, Harvard primatologist Richard Wrangham and evolutionary biologist and cognitive scientist W. Tecumseh Fitch of the University of Vienna. Lab animals with defects in neural crest migration are known to have smaller adrenal glands. If domestication has the same effect, the smaller glands should produce fewer stress hormones, which would reduce the animals’ stress levels and fear of humans and make them friendlier than their wild brethren, the team reasoned. Neural crest cells are so important in development that messing with them is bound to have many unintended consequences, such as the physical traits common across domesticated animals, the researchers posit.
“I think we may have the basic answer to something that’s been a puzzle for a long time,” says Wilkins.
Since 1868, when Charles Darwin first documented the signature changes in appearance that accompany domestication, researchers have invented just-so stories, which can’t be tested, to explain each characteristic’s development, says Greger Larson, an evolutionary biologist at Durham University in England. None of the many suggestions, Larson says, “have been particularly satisfying.”
But he is excited about the new hypothesis because it offers a fresh perspective on why so many disparate aspects of domesticated animals’ appearance change along with their behavior. He also applauds the researchers for offering a testable theory.
The idea was born in 2011, when Wilkins bumped into Wrangham at the Stellenbosch Institute of Advanced Study in South Africa. As Wilkins tells it, he was photocopying research papers about neural crest cells for a book he is writing on the human face. Wrangham told Wilkins that he, too, was interested in neural crest cells, but because of their possible role in domestication, a notion Fitch had planted in his mind several years earlier.
The two knew that other scientists had linked defects in neural crest cell migration to spotted coat colors, short jaws and small adrenal glands. Working with Fitch, they found more evidence in published research that deficits in the number, movement or action of neural crest cells could also cause the whole suite of physical and behavioral changes in domesticated animals. The only common domestication trait the researchers could not link to neural crest cells was curly tails.
The neural crest cell defects are probably the result of changes in dozens of genes, each producing a small effect on the cells’ behavior, the researchers propose.
But Anna Kukekova, an animal geneticist at the University of Illinois at Urbana-Champaign, who studies tame and aggressive silver foxes, says she sees a flaw: The physical and behavioral traits of domestication syndrome don’t always go together.
For instance, she says, when researchers bred tame and aggressive rats, white spots appeared just as often on the coats of mean as on friendly rodents. The result may indicate that tameness and coat color don’t have the same underlying causes, Kukekova says.
Larson, however, thinks the team is on the right track. But he says that they’ve ignored recent research, especially a hypothesis put forward by Susan Crockford.
Crockford, a zoologist and evolutionary biologist at the University of Victoria in Canada, suggests that changes in levels of thyroid hormone during early development could affect the entire constellation of domesticated characteristics.
“Thyroid hormone from the mother strongly affects embryonic development from the moment of conception onward,” she says. The hormone’s action may also impair neural crest cell movement, and is the ultimate source of the domestication traits, she says.
“The good thing about their hypothesis is that it is eminently testable: that, of course, is what makes it science,” Crockford says.
However, none of the three researchers who put forward the idea have labs set up to do the genetics, molecular and developmental biology and embryology needed to test it and will need other researchers to provide experimental evidence that either supports or falsifies their argument, Wilkins says. “Here we’ve had this had bright idea, but we’re asking other people to do the hard work.”.
F.W. Albert et al. Genetic architecture of tameness in a rat model of animal domestication. Genetics. Vol. 182, June 2009, p. 541. doi: 10.1534/genetics.109.102186.
T.H. Saey. Tamed fox shows domestication's effects on the brain. Science News Online, May 15, 2013.