By Ken Kugler, PIA Councillor
Australia has had its own pump test code since 1931, which has helped to guide the industry for almost a century. However the future of the code – which hasn’t been updated since 2001 – is somewhat uncertain.
Australia’s pump test code originated as ASCB9 and the first AS2417 code was published in 1980. This 1980s edition, in three parts, was based on the British code ruling at the time.
Our current 2001 edition of AS2417 is actually a direct text adoption of the ISO Standard ISO 9906:1999
At the time of writing, Standards Australia has advised on their website that all standards older than ten years have been listed, with a view to deleting them. AS24172001 obviously fits this category and thus has a very high possibility of being deleted, especially as it’s not a statute requirement of the National Construction Code.
In Australia, AS24172001 has been and still is the prominent pump test code for clients purchasing pumps for most water supply, water treatment works, fire protection pumps and similar applications where a guaranteed performance is critical.
The major importance of a pump test Standard for a user is the guarantee that a pump performance will be within a particular tolerance range for their requirement.
Performance parameters are flow rate, generated head, speed, and the power required for a specified flow rate and head. Finally, the pump efficiency is a calculated value from the power absorbed.
A manufacturer’s published pump performance indicates all the parameters, and in most cases, includes note advising the particular standard that the pump is guaranteed to meet.
For the pump industry, the test tolerances of a pump’s performance are the major issue that purchasers and suppliers concern themselves with.
Currently AS24172001 (ISO99061999) provides the following test tolerances for a pump:
Purchasers should be aware that most pump suppliers guarantee their standard general purpose pumps to meet the tolerance “Series or as per Annex A”.
To illustrate this, a manufacturer supplying a pump to provide a flow rate of 100L/s at 100m head will guarantee to supply a pump that will have a minimum flow rate of 91L/s at 100m or up to 109L/s at 100m.
Alternatively, the pump may deliver a minimum head of 93m at 100L/s or a maximum head of 107m at a flow rate of 100L/s.
Unfortunately, many specifiers do not realise that just because the pump has a guaranteed performance, it still may not meet their minimum performance criteria because of the allowable tolerance.
It is logical that as the current AS2417 is a complete take up of the ISO99061999 edition, then perhaps Standards should update to the current ISO99062012 edition.
What would this provide the industry with?
Examination of the table:
- Three tolerance grades remain in each standard, although the previous “Annex A” is now designated as“Grade 3”.
- All tolerance values are identical apart from the Grade 1 flow rate that has been increased from +/ 4.5{87a03eb4327cd2ba79570dbcca4066c6d479b8f7279bafdb318e7183d82771cf} to +/5{87a03eb4327cd2ba79570dbcca4066c6d479b8f7279bafdb318e7183d82771cf}.
- An additional “Acceptance Grade” now provides a “Unilateral” acceptance grade.
- Guarantee requirements are now clearly indicated as “Mandatory” or “Optional”. This was not as clearly indicated in AS24172001.
The Unilateral Acceptance Grades are a very interesting development. Essentially, these grades require that for a specified pump (a very important point) to meet 1U or 2U tolerances, it must meet the specified performance without a negative tolerance being applied. Only a positive tolerance is acceptable.
A negative side of this is that the power now has a very large positive tolerance. It will be interesting to see how purchasers and pump suppliers will address this issue, as the cost of the driving electric motor or diesel engine is a major cost item, both from a capital and operating point of view.
I suspect the clever purchaser will nominate an efficiency to be achieved rather than power.
ISO is essentially a European and British standard. However, Australian industries, based on American technology or Americanowned companies, have tended to nominate Americanbased test codes as their Standard here in Australia. The oil and gas industry is a typical user of American pump standards.
So what is the current American standard? The Standard is known as ANSI/HI 14.62011 Rotodynamic Pumps for Hydraulic Performance Tests.
The major point of interest of this standard is its foreword which states “It is in harmony with revised ISO9906…this means that users in all parts of the world…when specifying a pump hydraulic performance acceptance test, will be working with identical technical requirements and acceptance grades.”
Further investigation confirms that ISO99062012 and ANSI/HI 14.62011 are virtually identical in their content.
The Australian pump industry, its suppliers and its consumers need to take action to ensure they are not being left behind, or indeed more confused with the requirements in the future.