Writing!
The point, however, is that we have not been afraid of taking the first steps, which is often the biggest hurdle for an organisation wishing to embark on this journey. I do readily recognise that it is easier and safer to govern, employ and fund in the way we are used to; the way we’ve always done it.
The Trust for London is 127 years old. Our mission is to tackle poverty and inequality in London. We distribute around £9m each year to between 130 and 150 civil society organisations, think tanks and research institutions.
We do what we do in the field of diversity – race, gender, class, sexuality, disability, belief, age, etc. – and enabling and encouraging people to rise up the hierarchies in the Governance and Management teams, the motivation – if you want to call it – is because it makes us a better grantmaker, not for praise and plaudits or for insults.
Simply put, thinking about and encouraging a diverse range of people to rise up the hierarchies at all levels – governance, management and in developing the issues we prioritise for engagement and funding, the research we commission, the organisations we fund, etc. has helped us to be closer to the issues affecting Londoners’ experiencing poverty and inequality.
So, how have we got to this staging post? It has not been by accident or social osmosis. It has been by design and by not fearing failure, the ball and chain of social change. I’m going to give examples of the sorts of things we’ve done in our journey to address diversity shortcomings. I hope you’ll find them useful.
In terms of governance, we carry out skills and diversity audits. In the diversity audit, we ask trustees to state if they have lived experience of poverty. We also ask applicants responding to openly advertised vacancies on our board if they have lived experience of poverty. Whilst this is self-defining, it gets through that we consider it to be important. We are asking our committees to consider co-opting people with a recent lived experience of poverty.
Despite not being required to by law, we publish gender and ethnicity pay gap data; as we do the difference between the highest and lowest paid; and between highest paid and someone earning the London Living wage for 35 hours a week (our normal working week).
As an important aside, we were instrumental in developing the London Living Wage with Citizens UK, a great civil society organisation. 3,500 organisations across the UK, including 50% of the FTSE 100 companies, have signed up to pay the living wage, including down the supply chain. As you’ll appreciate, the main beneficiaries are women and people from minority communities, people who are employed in the lowest paying jobs – catering, cleaning, retail, etc.
Data are mirrors we hold up to ourselves – not to narcissistically admire ourselves but to spot the flaws so that we can act to address the shortcomings. Data and evidence are the first tools to enable change.
In terms of management, we carry out a diversity audit to shed light on the makeup of our staff. We have looked at our HR policies and made a commitment to advertise vacancies as being available to full and part-timers; and in the most recently advertised position – Director of Policy, a senior management team position – the person specification asked for lived experience of poverty/community work experience and gave it a high weighting.
We are re-visiting our working from home policy and we already allow flexible working. We have reasonably generous maternity, paternity and adoption provision and our pension provision is good.
We encourage training and development and we look favourably on internal promotion when appropriate. We have 20 staff, 17 FTE. Four of the longest serving staff – all women – started in very junior positions many years ago but now hold positions as: IT Manager; Finance Officer; Facilities Manager and Senior Grants Administrator.
Our problem, I suspect in common with other funding agencies, is that we don’t have significant staff turnover.
Our offices are fully accessible and in our search for new premises, we have put accessibility beyond basic Disability Discrimination Act requirements at the top of the list.
I suppose what I’m saying is, we have questioned whether our systems and procedures are inadvertently placing barriers to the employment and promotion of a diverse work-force.
In terms of operations, again, data has been critical. We publish London’s Poverty Profile which, using publicly available datasets, looks at 20 indicators across nine categories – including education, housing, employment, low pay, income inequality and health. This information is made available via a dedicated website and can be interacted with to get granular information – e.g. which sections of London’s population are disproportionately affected.
We have not relied entirely on data. We have also used qualitative information from, and partnerships with, our grantees to embark on initiatives e.g. tackling Female Genital Mutilation; Modern day Slavery; and Safeguarding Children’s Rights – preventing faith-based abuse of children. We are about to start an initiative on disabled people’s rights.
I could tell you that you just have to appoint a diverse range of people and be done with. But let me tell you that, as someone from a minority community, I wouldn’t appreciate that. I don’t wish to be appointed to assuage guilt or to salve moral conscious. I am attracted to organisations that are trying to look at themselves with a view to being relevant to the people they were established to serve. There’s plenty of talent out there amongst women, minority communities, disabled people, etc. You just have to be willing to share the power you have.
By doing so, you will be a better and more sensitive grant maker. But by not doing so, you may merely be perpetuating the issue your organisation was established to address. That may be fine for now but remember that a culture that doesn’t change and adapt, becomes irrelevant and eventually dies.