Last?
As it turns out, SOAP is not very popular amongst the Python community. We have fantastic support for XMLRPC, but SOAP support is surprisingly difficult. At best, it's incomplete. At worst, you have to pick your SOAP library just for compatibility.
After spending a fair bit of time Googling, I found a reference to a SOAP library called "Suds". This looked to be the simplest way to get myself speaking to the SOAP servers. Suds works, and it does things properly. Unfortunately, the SOAP servers I needed to speak to do not do things properly.
SOAP uses a WSDL file to tell clients what procedures are available and how to call them. The servers I needed to speak with did not provide a WSDL file. Instead, we have a static WSDL file, and from that we are supposed to be able to make a stub library, and using that we can submit jobs. This mechanism did not sit well with Suds at all.
After digging, I did find the WSDL file on all the SOAP servers. I thought I was set. I began submitting information, only to get way too many errors back. Digging more, I found out why: I was only submitting to one SOAP server, not all of them. The WSDL file on our servers hard codes the URL, so that it points to the first server in the group. I had to make a custom WSDL file for each of the servers.
Fortunately, that turned out to be relatively easy. I just did a simple string replacement in the incoming WSDL file (so that the URL always pointed to the correct SOAP server), saved it to disk, and pointed Suds at the server-appropriate WSDL file url (''). Suds parsed it correctly, and sent the information to the appropriate SOAP server.
If I had the time, I'd like to help take Suds to feature completion. It looks like a nice library. I don't, though. I will, instead, be grateful that they've done the hardest work, and that I could use their library with my problem. It did solve it, and fairly easily, too (especially in comparison to having to write my own code).