Recent changes to Google's search algorithm may have exacerbated online book piracy, according to data compiled by online textbook subscription service Perlego.
Every year, American publishers lose out on around $300 million from people downloading illegal copies of books online, according to a 2017 study published by Digimarc and Nielsen. Mary Rasenberger, CEO of the Authors Guild, said in 2019 the figure had likely grown.
Perlego, which charges users a monthly subscription to access academic, professional, and non-fiction e-books, monitored five years' worth of search traffic to the top online book piracy sites.
The firm used SEO analysis tool Ahrefs, which tracks how live websites "link to each other and what keywords they rank for in search results," and with Keywords Everywhere, a tool that allows users to more precisely monitor Google search traffic.
It detected recent surges in traffic to the most popular book piracy sites, which Insider is choosing not to name, that coincided with a two-part "core update" by Google to its search results through June and July.
Spikes in traffic to piracy sites coincided with Google's search updates
This graph, supplied by Perlego, shows traffic to piracy sites before and after Google's search algorithm changes in the summer.
Perlego
The above graph, supplied by Perlego, shows traffic between September 2020 and September 2021 to several book-piracy sites, represented by the colored lines. The orange dots represent Google's two-part algorithm update.
One piracy site, represented by the blue line, saw traffic soar 478% since the first part of the update in June, growing from around 31,000 unique visits per month to 183,000.
The site represented by the red line saw a 200% spike in traffic in the same period, up from 78,000 visits to 236,000. While traffic to the site in yellow tailed off slightly in September, it has still seen massive growth, up 258%, from 43,000 visits per month before the update, and 154,000 last month.
"After Google's June and July updates, we saw online piracy sites shooting up," said Tom Blackshire, director of SEO at Perlego, who told Insider publishers were "losing a ton of money" as a result. "Google wants to ensure people can find what they're looking for, and with the last two updates, they've focused in on that — but now the piracy sites appear to be being rewarded as a result.
"You have to respect that they're dealing with trillions of results, and it's not like someone at Google is like: 'Let's screw over the publishers,' but they are creating these algorithms and not necessarily paying full attention to what the output is."
Publishers have been warning about the cost of book piracy for years
One factor driving online piracy is the cost of some academic textbooks. One engineering book, "Rocket Propulsion Elements," can cost up to $125 to buy legitimately. Based on the number of times the book has been searched for across piracy sites, Perlego calculated that US publishing house Wiley stands to lose almost $900,000 a year on that book alone.
Commenting on Perlego's findings, Aref Matin, chief technology officer at Wiley, told Insider the piracy of academic materials was "a significant and ongoing challenge," that "blurs the line between high and low-quality information, and threatens the security of people and institutions across the globe."
It isn't just Google who should be tackling the issue, he said.
Matin said: "The reality is that this issue can only be solved through a multi-pronged approach that includes efforts from content creators, governments, search companies, and individuals.
Matin added that search engines were in "a unique position," suggesting they could not only remove pirated content found online, but also "do so more proactively, by implementing smarter technologies to prevent infringements from occurring at scale."
Stephen Lotinga, CEO of the UK's Publishers Association, told Insider the rise in online piracy was an "increasing problem."
He said: "Governments, platforms and other internet intermediaries all have a responsibility to tackle this problem. Accessing pirated material is illegal and jeopardizes the creation of academic texts in the future."
It's possible that the surge in traffic to piracy sites is temporary and may drop after another tweak by Google. The firm tweaks its algorithm in the hopes of improving users' experience of its search engine on almost daily basis, but isn't always transparent about how these changes will affect other websites' rankings.
Several times a year, Google — in its own words — makes a "significant, broad changes to our search algorithms and systems." These core updates can have a big impact on what appears in Google's results pages, depending on how informative, relevant, or credible the new algorithm deems websites in relation to a given search query.
According to Google's transparency reports, the firm has received requests for more than 5 billion different URLs to be de-listed from its search results under copyright law over the past 20 years. The company says that it "regularly receives requests to delist content," but adds that it cannot "act as a mediator," and advises complainants of their right to sue those breaching copyright law. Google declined to comment further.
Are you a current or former Googler with more to share? You can contact this reporter securely using the encrypted messaging app Signal (+447801985586) or email (mcoulter@businessinsider.com). Reach out using a nonwork device.