On Monday, the Supreme Court voted to uphold an Indiana law that requires voters to show a photo ID to cast a ballot. The ACLU and Indiana Democrats had challenged the state law, passed along party lines in 2005 by a GOP-controlled legislature, which opened the debate on increasingly restrictive voter registrations and identifications in the highest court in the land.
Indiana Republicans and their national colleagues, seen by many to benefit from low voter turnouts, particularly amongst demographics they fare poorly with—minorities, elderly and poor voters—argued that without photo IDs, elections were imminently susceptible to fraud. Detractors, including state and national Democrats, civil rights groups and the ACLU, believed that photo IDs place an unnecessary burden on vulnerable voting groups that could lead to systematic disenfranchisement. Indiana’s law is of particular national interest as is seen as the most restrictive in the country, stating that the photo ID, though provided free of charge, must be government-issued.
The highly partisan issue was anticipated to rekindle the liberal/conservative divide of the court in a manner akin to the much-criticized Bush v. Gore 5-4 decision in 2000. Yet the court splintered three ways, and not entirely along its traditional ideological divides.
In the 6-3 decision of Crawford v. Marion County Election Board, Justices John Paul Stevens and Anthony Kennedy were joined by Chief Justice John Roberts in accepting that states had a legitimate concern in deterring fraud and rejected the ACLU challenge that the law was unconstitutional on its face—noting that the concept of photo IDs did not inherently violate the right to an unhindered voting access. This collective opinion did hold that in different situations, where individual voters could prove that their rights were violated, the justices might consider a different result.
Justices Antonin Scalia, Clarence Thomas and Samuel Alito, often considered the most conservative members of the court, went further than their assenting colleagues by saying that no discrimination had occurred since all voters were subject to the same requirements and that the burden of photo IDs was minimal and justified in order to deter fraud in elections. This broader interpretation would validate photo ID requirements across the country as minimally invasive to the public and necessary to preserve an untainted process.
While the Roberts court, and particularly its most conservative members, had previously expressed cynicism in on-face challenges, the argument was brought against the law as a whole and before it went into effect for the 2008 primary to nullify the legislation without having to wait for a particular breach of voting rights when the actual outcome of the contest was already a thing of the past. The majority court also went out of its way to note that while partisan considerations may have played a role when the law was originally enacted in Indiana, its current application was a neutral one.
Justices Ruth Bader Ginsburg and David Souter co-signed their dissent, while Stephen Breyer wrote his own dissenting opinion. All variously took issue with the indeterminate claims of fraud in Indiana superceding the rights of citizens to vote and the precedent now set for a creeping process of “discouraging or disabling” people from voting.
Chiefly at issue in this case is the balance and measure of disenfranchisement and fraud. Neither fraud nor disenfranchisement appeared common in Indiana and many of the justices struggled to quantify the repercussions of the ruling. The Wall Street Journal noted that of 165,000 ballots cast in the Indianapolis mayoral election last November, only 34 voters didn’t have ID and were then allowed to cast provisional ballots. Only two then chose to travel to the county clerk’s office to show proof of identity. Conversely, the paper quotes Ken Falk, legal director of the ACLU of Indiana, who says that the state has no documented problem with voter impersonation or in-person voter fraud. Both partisan camps, therefore, ran into the problematic situation of not having a true victim—neither side could point to in-person fraud or known voter disenfranchisement—and the case became increasingly rhetorical, political and philosophically sweeping as a result.
As with many Supreme Court cases, it is the intangible statement sent by the court rather than the tangible, applicable laws upheld or overturned that ultimately reigns preeminent. Indiana will be allowed to keep its voter ID system for next Tuesday’s critical Democratic primary between Barack Obama and Hillary Clinton, but perhaps even more importantly, the court has sent the message that increasingly stringent methods of voter identification are acceptable, if not downright encouraged, to discourage fraudulent results. In the words of Justice Stevens, states have an interest in “…protecting the integrity and reliability of the electoral process.”
In Colorado, two recent bills sponsored by House Republicans sought to enact a similar tightening of voter identification. Lakewood Rep. Ken Summers’ HB 1039 wanted valid photo IDs when voting, Highlands Ranch Rep. Frank McNulty’s HB 1177 wanted registrants to show proof of citizenship. Both were defeated in the state affairs committee on straight party-line votes.
Twenty-three states essentially do not require proof from voters other than those who are voting for the first time by mail without having been previously verified, as federal law demands. Colorado’s voter ID requirements are lenient compared to Indiana, accepting driver’s licenses, passports, government IDs, named and addressed checks, naturalization documents or a pilot’s license, among others.
What the court ruling makes clear is that accessibility to the polls may hinge exclusively on the balances of power in state legislatures. This is not necessarily a bad thing, but must serve as a warning to all voters that the highest arm of the judiciary has already tipped its hand in the matter—very little checking or balancing will go on once a state’s majority party has its say.
-- Joe Horton