How unequal is India? The question is simple, the answer is not.
For some 60 years, the only reliable information about India’s inequality was coming from the annual National Sample Survey conducted from 1951. NSS is one of the most venerable surveys in the world of poverty and income distribution statistics. India started fielding it soon after its independence: the survey was supposed to track how the new government fought poverty, to provide information on caste differences, rural-urban gap, caloric intake, especially of the poor and many other statistics. Since its main concern was with poverty, the decision was made to survey consumption, that is, how much people actually consume (do they have sufficient number of calories) rather than income (how many rupees they earn).
For all these decades since 1951 NSS was the key instrument that allowed researchers from India and the rest of the world as well as Indian policymakers to know what is happening with India’s population. India could thus boast to have had a longer series of annual surveys than most rich countries (that often launched their similar surveys in the 1960s). But in addition the survey also benefited from some reflected glory which had to do with the ideals and hopes raised by the Independence and thus it had a bit of this Third World-Bandoeng Summit-Mahalanobis glow always attached to it.
But the problems started in the 1990s when the survey numbers began to diverge more and more from National Accounts statistics: NSS was showing consistently lower rates of growth, and higher poverty than many people thought it should be given India’s fast growth. This led to the famous Great India Poverty debate in which participated Angus Deaton, Amartya Sen, Jean Drèze, T.N. Srinivasan, S. Subramanian, Martin Ravallion and many others. Several representative articles are given here and here and here.
The gap between the slow moving survey mean and much faster changes in per capita GDP was also explained by the failure of NSS to capture top incomes. The top incomes may have been pulling up the mean (presumably reflected in GDP per capita) and if surveys continued, partly by design and partly by the reluctance of the rich to participate, to be focused on the bottom of the income distribution, that could explain the rising gap between NSS and national accounts.
And if indeed that was the reason, or one of the reasons, then another unpleasant conclusion imposed itself: inequality in India may be (far) higher than implied by NSS data.
And indeed, as the graph below shows, NSS kept on producing a fairly stable consumption Gini (calculated here on household per capita basis) over several decades, with only a small increase in inequality after India’s sharp turn toward capitalism in the early 1990s. That Gini, ranging between mid- and higher-30s, made India inequality look about the same as in developed countries.
/>
But until recently we had no other reliable and nationally-representative survey to confront NSS with. Now, thanks to the joint work by University of Maryland and National Council of Applied Research in New Delhi, we have (harmonized by LIS), the first income based surveys of Indian population for 2004 and, just released by LIS, another same survey for 2011.
And the results are very different from NSS’s. First, Indian Gini is remarkably consistent in both 2004 and 2011 and is (on per capita basis) 51 Gini points. This is at the level of Latin American countries and is some 15 points (or almost 40% ) higher than the Gini’s calculated from NSS. Thus a key question is immediately asked: is India’s inequality more like Latin American? NSS was saying for years that it is not; the India Human Development Survey (IHDS) argues it is.
For 2011, I have both micro data from NSS and micro data from IHDS and when I compare income/consumption by each percentile (note that these are entirely different people though), the results do make sense. For the lowest percentiles, consumption is about twice income, and everybody up to the 33rd percentile consumes more than their income (which you would expect in a poor environment). After that point, consumption consistently and monotonically falls short of income (that is, there is saving), so much that among the top 5%, income is twice as high as consumption (saving rate is 50%). Overall, the mean per capita income from IHDS is 47 percent higher than the mean per capita consumption from NSS, and as we have said, Gini is some 15 points higher.
This “reasonableness” of the data, and the absence of discontinuities when comparing income and consumption leads one to believe that it is possible that both NSS and IHDS provide accurate information (with likely underestimation of top-end consumption and income), but that income distribution in India is much more unequally distributed than consumption.
So if we compare India with other countries that use income surveys, this is how it looks (see the figure below). India seems slightly more unequal than Brazil, and more egalitarian than only South Africa.
There are many other issues that are worth exploring here, in particular if we want to look more carefully at the consistency between the two surveys, but I would like to end by considering the role of the new income survey for India from an unusual angle.
As mentioned before, since NSS was the only game in town, all our global poverty and inequality statistics were done using NSS. Now, if we replace NSS with the new income survey as I have done for the global inequality calculation for the year 2011 (unpublished), you may expect that the greater inequality revealed by IHDS would push global inequality up, especially since India is such a populous country. Right?
Wrong.
What happens is that global inequality goes down by approximately 1 Gini point since the higher income levels implied by IHDS push Indians toward the middle of the global income distribution and more than offset the contribution to higher global inequality that comes from the stretched-out Indian distribution. Thus, somewhat paradoxically, a global implication of a new, and I think more reasonable, approach of viewing India as a country with Latin American levels of income inequality is that global inequality, as calculated so far, might have been overestimated.
In conclusion, more unequal but richer India, makes the world more equal.
Note: Only a member of this blog may post a comment.