The aims of this study were to investigate growth and fruiting of C. peruvianus under different climatic, soil, and water conditions in the Negev desert of Israel and to study the biology of pollination and fruit maturation.
Fruits were picked at weekly intervals from first color change until 29 days after full color change and the fruit quality parameters [total soluble solids (TSS), reducing sugars, titratable acidity and pH] were analyzed in the pulp. Changes in fruit length and diameter were determined during fruit development for attached fruits.
The total shoot length and the biomass were higher at Besor than at Ramat Negev and Qetura, while at Neot Hakikar growth was almost arrested (Table 1). Plants at Ramat Negev showed visible cold injury such as brown spots or yellowing after temperatures dropped to -7°C for several hours. Since the plant material and the agrotechniques used were similar (plants were propagated from the same batch of seeds) in all the plots, variations in growth can be attributed to the diverse environmental conditions prevailing at the different locations. The fresh water and moderate temperatures favored growth at Besor, while water salinity at Qetura and Neot Hakikar, and low temperatures at Ramat Negev inhibited growth. Sensitivity to low salinity was also shown for other cacti species such as Opuntia ficus-indica (Nobel 1988; Nerd et al. 1990). The salinity at Neot Hakikar caused greater stress to the plants than that at Qetura, probably because the main salt ions, sodium and chloride, in the water at Neot Hakikar, are more toxic than the ions, calcium, magnesium, and sulfates, in the water at Qetura.
Flower production was negligible at Neot-Hakikar and Ramat Negev, but abundant at Besor and Qetura. The low winter temperatures at Ramat Negev and the water salinity at Neot-Hakikar may have inhibited flowering.
The natural fruit set of 15 individual plants at Besor varied in the summer, 1990, between 0 and 95%, and pollination studies were conducted to evaluate the origin of this variation.
The main insects visiting the flowers were bees, although small flies were also observed. The insects visited the flowers when the flowers are opening before sunset, and after sunrise, when the flowers are closing. The placing of beehives in an plantation would increase fruit set and improve fruit production.
Flowering of C. peruvianus occured in two waves. The first wave starts in spring (May) and the second in mid-summer (July). Detailed observations made on the first wave in 1991 showed that there are considerable variations between the various seedlings in both the onset and the duration of flowering period, which may last from two weeks to one month.
The color of the fruits varies from violet-red through orange to yellow and the fruit length ranges from 7 to 10 cm. The taste of the fruits also varies markedly, some fruits are juicy and aromatic, whereas others are mucilagenous and inferior in taste. Furthermore, the fruits differ in their tendency to burst upon ripening. A reduction of irrigation during the crititical stage of fruit development might prevent this phenomenon.
Fruit quality parameters (TSS, reducing sugars, and titratable acidity of the pulp), fruit weight, pulp to peel ratio, and percentage of peel and pulp dry weight of different individual plants from Besor and Beer-Sheva are shown in Table 2 and 4. Significant differences were found in titratable acidity of the pulp and dry weight of the peel as well as in fruit weight and pulp to peel ratio. Preliminary taste-tests showed, that fruits with a higher content of titratable acids were less tasty than the fruits with a lower acidity. Fruits of the various individual plants were all harvested in the stage of full color change, but since they were not tagged at the beginning of color change, they might have reached different stages of ripeness at harvest and this fact might partially be responsible for the differences in the quality parameters.
Plants propagated by seeds were self-sterile. Open pollination led to a fruit set of between 0 and 95%, depending on the individual plant, but experimental cross-pollination resulted in 100% fruit set and heavier fruits with more seeds. The pulp weight was positively correlated to the seed number. Bees were the main insects visiting the flowers. The placement in the orchard of beehives may be desirable to maximize fruit yield. Selection for plant appearance, flowering time, and fruit appearance and quality is now needed for the commercialization of C. peruvianus.
zSegments, 30 to 40 cm in length, were sampled from three plants at each site. Plants were oven dried at 70°C, and the total stem length used to calculate plant dry weight.zSegments, 30 to 40 cm in length, were sampled from three plants at each site. Plants were oven dried at 70°C, and the total stem length used to calculate plant dry weight.
zValues are means of 7 to 10 fruits. Values followed by different letters for each seedling were significantly different at p>=0.05.zValues are means of 7 to 10 fruits. Values followed by different letters for each seedling were significantly different at p>=0.05.
zDescriptions of the fruits refer to fruits at full color change.zDescriptions of the fruits refer to fruits at full color change.
zValues are means of 7 to 10 fruits ±SE.zValues are means of 7 to 10 fruits ±SE.