When Victoria's Secret recently turned West Edmonton Mall into a bra-buying madhouse for its Canadian launch in August, most in the Great White North shrugged at the introduction of yet another major U.S. brand into their retail marketplace.
Real estate industry watchers, however, saw the launch as part of an ongoing trend - a greater recovery in the domestic retail real estate market powered largely by big-name foreign brands migrating to Canada in search of prime mall and main-street spaces - and shoppers ready to buy.
"There are two reasons why American and foreign retailers are looking to Canada: relative value combined with the fact there is a stronger and more positive economic outlook," says Stan Krawitz, president of Toronto-based real estate brokerage Real Facilities Inc.
Mr. Krawitz explains that for foreign retailers, a diverse array of retail real estate opportunities available, a relatively robust economy in comparison to that of the U.S. and much of Europe, as well as bargain-priced rents are a major draw for big brands that are seeking everything from urban street front to suburban big-box configurations.
Just how cheap is our real estate? According to a recent report by Colliers International, Canada's two priciest high streets by cost per square foot - Ste-Catherine in Montreal and Bloor in Toronto - rank 32nd and 33rd in the world, respectively, compared to other premium retail corridors around the world.
Those who want to set up shop on Paris's posh Champs Élysées or New York's tony Fifth Avenue can expect to shell out a whopping $1,250 (U.S.) per square foot. Prime space in Montreal or Toronto, in contrast, costs a mere $294.12 (U.S.) per square foot.
That helps explain why major American players such as Brooks Brothers, Bath and Body Works - whose parent company, Limited Brands, also owns Victoria's Secret - and Anthropologie also set up shop in Canada in the past two years.
Joining them was Denmark-based fashion house Bestseller, which expanded its retail operations into Canada in mid-2009, introducing men's casual brand Jack and Jones and the women's clothing line Only in Ontario and Quebec.
According to Steve Tabah, Bestseller's buying director for Jack and Jones in Canada, the relative strength of the Canadian retail market and stronger consumer confidence helped the firm achieve its aggressive retail expansion goals after first establishing a wholesale presence here in 2004.
But even at the height of the recession, gaining a foothold in major Canadian malls took time. Landlords, it seems, could afford to be finicky about their new tenants.
Despite the firm's strong reputation in the European market - the multibillion-dollar fashion giant employs more than 41,000 people globally and boasts more than 5,700 stores in 43 countries - Bestseller was still forced to fight for these sought-after retail spaces.
"The mall owners want serious retailers and nice shops in their malls who want to be there for a while and be successful," Mr. Tabah explains, adding that Bestseller's average per-store design and construction investment is around $400,000. "When the mall owners saw that we were serious retailers and the mother company had the money to invest [they were impressed] We were offered many good locations after that."
Bestseller plans to add at least 200 more retail stores to its multibrand Canadian portfolio in the next five to seven years, according to Mr. Tabah.
Of course, this renewed foreign retail interest has given rise to a veritable dream scenario for landlords eager to buttress their top-tier properties with high-profile international brands.
"The landlords are looking for retailers who will deliver high productivity, selling sexy products that compete on brand and not on price," says Harley Oberfeld, chief executive officer of Montreal-based retail advisory firm Oberfeld Snowcap. Mr. Oberfeld cites lingerie brand Victoria's Secret as an example of a landlord's ideal tenant. "They want to know that [a brand]can create volume and productivity."
And it's not just Montreal and Toronto benefiting from this foreign-led retail real estate renaissance. According to Antony Karabus, PricewaterhouseCoopers' Toronto-based retail consulting services leader, suburbs and downtowns across Canada from Halifax to Calgary to Vancouver are experiencing a boom as retailers either build out new big-box stores in the suburbs or clamour for prime street front spaces in downtown areas.
While he predicts a demand for even more shopping-centre-style real estate, Mr. Karabus points out that retailers entering the Canadian market are eyeing a wide range of property opportunities from new-build greenfield projects to store-in-store concepts as retailers look to maximize foot traffic and existing store productivity by allying with complementary brands.
So, what does this red-hot real estate market mean for smaller Canadian retailers? According to Mr. Oberfeld, a lot more competition, which is a good thing - assuming companies keep pace with their international rivals.
"Canadian retailers need to re-evaluate their businesses and they need to think and operate as if they were a global retailer in order to effectively compete if they're going to be in high-profile real estate across Canada," he says. "That's how the market has changed."
.....................................................................
The invaders
A number of major American brands entered the Canadian market in the past few years in search of lucrative expansion opportunities and shoppers still prepared to buy. Here's a breakdown of some of the most notable:
Anthropologie: The funky women's retailer set up shop north of the border last year in an effort to appeal to fans of earthy fashions and quirky household accoutrements.
Brooks Brothers: The preppy clothing retailer opened its Canadian flagship store in Toronto's Royal Bank Plaza last year. Their target: Hogtown's high-end consumers who sport decidedly conservative sartorial tastes.
Bath and Body Works: The popular skin care and bath brand launched in Canada in 2008, following the acquisition of Canadian lingerie chain La Senza by its parent company Limited Brands. The chain now boasts close to 50 Canadian locations.
Victoria's Secret: Limited Brands' lingerie powerhouse made its debut at West Edmonton Mall and began rolling out across the country this year to great fanfare - including a little help from its bevy of ribbon-cutting supermodels. The goal: To capture a large chunk of the $2-billion-a-year Canadian lingerie market.
Loews: The U.S. home improvement giant entered the Canadian market with its eyes fixed on stealing market share from the likes of Home Depot and Canadian competitor Rona, and has plans to add dozens of new stores over the next few years.