It seems as though potholes appear overnight, especially during the colder months. This is because once the top layer of a roadway has been impaired, a pothole grows quite rapidly. Daily wear and tear, extreme temperatures and cuts from construction or utility work can create cracks in the road surface.
Roads are like skin, they are extremely strong until they are pierced. Once an even small crack in that sealed road surface appears it becomes easy for water and moisture to penetrate and start causing trouble.
After that initial crack, water penetrates through the layers of the roadway. During the winter, this water freezes and expands – the so-called freeze-thaw cycle- pushing up the road surface and widening the cracks. When summer returns, the water thaws and creates empty pockets that eventually collapse under the weight of traffic, leaving behind potholes.
The challenge for a road crew is to understand where the early warning signs of a pothole are before it actually forms. In addition, roads are large meaning that it could take several days to survey the area looking for these early warning signs.
It may seem as though most departments of transportation cannot keep pace with their region’s ever-multiplying potholes but it is really a symptom of the complexity and size of the problem they are tasked with.
During winter, citizens call in pothole repair requests and departments of transportation become busy reacting to incoming issues in order to maintain a safe travel environment. However, permanent repairs cannot be made in cold or wet weather – the materials simply do not work in that environment. Instead, a gravel and asphalt mix called a “cold patch,” is used as a temporary fix but does not completely mend a pothole. Areas repaired with a cold patch will continue to acquire damage until a permanent fix can be done in the proper weather conditions – but the alternative is much worse. Dedicating materials and labor efforts to temporary pothole repairs doomed to be made multiple times in a single season is a very inefficient way to spend our resources.
“This sort of thing doesn’t happen in Scandinavia or France, where they mend the roads properly. A well-maintained road will withstand snow and ice without a problem. This is a legacy of 25 years of government underfunding and the siphoning of road maintenance money into other projects at a town hall level.”
-David Weeks, director of the AIA
Tiny Problems Can Quickly Become Big Problems
For a road network to be well-maintained we need to know how it is degrading, where that degradation is happening, and to what extent it is already degraded. The longer maintenance is deferred, the larger pavement distresses and the cost to fix them become. Sealing surface cracks and preventing water from penetrating the subsurface of the road is the most economical approach. Once moisture infiltrates the layers of the roadway, potholes develop rapidly and the road is lost.
In order to know how a road is degrading, we have to perform regular inspections. Currently, because of a lack of effective tooling, many communities evaluate their roads every five years and lack a long-term roadway plan. This has resulted in spending critical funds on quick fixes and emergency responses rather than investing for better planning and ultimately a better road network. With regular roadway assessments, we can better understand where potholes are likely to appear and employ preventative measures five, or even ten, years in advance to preserve the lifespan of a roadway.
In the last few years, more advanced and precise technologies have come to market that enables any sized community to affordably get this level of assessment. While even a few years ago, this type of resource would have been prohibitively expensive for all but the state DOTs, with the emergence of AI and smartphone data collection they can now be found at a much lower price point. Definitely worth every community rethinking their current approach to road maintenance.
“The cost of addressing minor deficiencies is much less than addressing major deficiencies. We have to do road maintenance when the roads are in fair-to-good condition, rather than waiting until they are in poor condition.”
-Larry Galehouse, director of the National Center for Pavement Preservation (NCPP)