The Corporate Credit Team at Janus Henderson Investors explain the benefits of integrating Environmental, Social and Governance (ESG) factors into investment decision-making. Key takeaways The concept of ESG analysis has evolved over the years and is becoming integral to fundamental credit research. The Corporate Credit Team believes that rigorous application of ESG analysis can improve risk-adjusted returns. Sound investment sense, growing client demand and efficient capital allocation underscore the importance and relevance of ESG analysis. ESG stands for Environmental, Social and Governance, and refers to three central factors in measuring the sustainability of an investment. It was derived from the ‘Triple Bottom Line’, also known as the ‘People, Planet and Profits’ (PPP), a concept introduced in the 1990s. It argued that businesses should focus on each of the three ‘P’s and not just on ‘Profits’, since they were equally important for any commercial enterprise to be sustainable. This concept evolved into the focus of ESG, which today is the bedrock of Sustainable and Responsible Investing (SRI). /> Environmental criteria examine how a business contributes to and performs on environmental challenges (e.g. waste, pollution, greenhouse gas emissions, deforestation, and climate change). Social criteria look at how the company treats people (e.g. human capital management, diversity and equal opportunities, work conditions, health & safety, and product misselling), while Governance criteria examine how a company is governed (e.g. executive remuneration, tax practices and strategy, corruption and bribery, and board diversity and structure). At the heart of ESG investing is the simple idea that companies are more likely to succeed and deliver strong returns1 if they create value for all their stakeholders – employees, customers, suppliers and wider society including the environment – and not just the company owners. Consequently, ESG analysis considers how companies serve society and how this impacts their current and future performance. ESG analysis is not just about what the company is doing today. Consideration of future trends is critically important and should inherently include disruptive change that can have significant implications for a company’s future profitability or its very existence. Our approach to ESG analysis We look at companies in-depth from E, S and G perspectives to evaluate their standing relative to peers. Our ESG philosophy is built on the belief that rigorous application of ESG analysis can improve risk-adjusted returns and company engagement is an integral part of successful investing. Just as with other credit metrics, we would expect improving ESG profiles to lead to a lower cost of capital. We believe companies that pursue meaningful ESG improvement should increase the potential to outperform as the cost of capital declines and credit spreads tighten. Conversely, if a company has material ESG risks and is not actively mitigating these risks and improving their ESG profile, it is very likely that its bond prices will suffer. Identifying and measuring ESG risks and opportunities has the benefit of simultaneously supporting environmental and social benefits. There are many ways to incorporate ESG into investment decisions. The main applications tend to be ethical/values-based investing, integrated ESG and sustainable/impact investing. In ethical investing managers employ a negative screen approach to generate ‘ethical or moral returns’ and screen out controversial ‘sin’ sectors. While negative screening is very straightforward to implement and has historically been used by early adopters of sustainability principles, a growing number of firms are now also aiming to apply ESG in order to take advantage of opportunities and select sectors and companies based on their positive ESG performance. This leads to a more holistic ESG integration that is better placed to maximise risk-adjusted returns. Impact managers go a step further in applying ESG considerations and aim to deliver positive impact via their investments in companies and governments that generate a measurable net positive impact for society and the environment alongside positive returns. There is no one way to apply ESG, so understanding how an investment manager applies ESG in their investment process in order to achieve the strategy’s objective is important for clients. Why do we care? Because it makes sound investment sense It is our fundamental belief that ESG considerations enhance risk-adjusted return potential by reducing investment risk and creating investment value. A well run and responsible company that cares about its people, customers and the environment, we believe, is more likely to exhibit a greater level of resilience and outperform its peers than one that does not. ESG analysis can provide valuable insights about factors that can have a significant impact on the financial metrics of a company and therefore better inform our investment decisions. ESG analysis can be complex. When taking ESG considerations into account, it is not just a case of evaluating the products and services provided by a company, but also its behaviour, conduct, supply chain and other considerations in running the business. ESG analysis must also consider the future, taking into account not only a company’s latest ESG disclosures, but also its strategy, overall impact and evidence that it is keeping to its commitments and standards. Hence we believe it is not advisable to formulate investment decisions based on purely backward looking historical data and believe a more forward-looking, dynamic approach is needed when considering ESG risks and opportunities. This is why our proprietary ESG analysis and ESG ratings are integrated into our credit research. While exclusion-based strategies adopt a negative approach to investing, our holistic approach to ESG takes a more positive stance and also looks for opportunities where companies are actively transitioning and improving their ESG profiles. The combination of improving credit stories and improvement on ESG grounds can help achieve positive outcomes for the environment and society. Because our clients care In our most recent survey of client attitudes, when asked about the importance of ESG integration in investment, 78% of clients said it was as or more important than five years ago.2 Furthermore, by 2025, the so-called ‘values-driven generation’ – millennials – will represent three-quarters of the global workforce.3 A Morgan Stanley study found that millennials are twice as likely as the general population to invest in companies with social or environmental goals.4 And in North America alone this generation, alongside Generation X, is set to share a wealth transfer in the region of $30 trillion from their baby boomer predecessors in coming years.5 The pressure from asset owners to invest responsibly and have a more sustainable mindset is therefore expected to grow significantly. Because we believe that facing up to sustainability challenges and strategically allocating capital can help make good long-term investment decisions The world faces major sustainability challenges – such as climate change, ageing population, and inequality – which require radical solutions that will bring huge yet hard to predict changes to the global financial system. By facing up to these challenges, recognising that capital allocation decisions have a real impact on the world, and holding bold visions of the future, investors can hope to make good long-term investment decisions. 1Various studies exist that demonstrate that incorporating ESG factors can have a beneficial influence on returns. For example, “Sustainable Investing and Bond Returns: Research study into the impact of ESG on credit portfolio performance”, Barclays 2016. 2Janus Henderson Customer Panel, October 2019. 3Big demands and high expectations, The Deloitte Millennial Survey, 2014. 4Sustainable Signals. New Data from the Individual Investor, Morgan Stanley Institute for Sustainable Investing, 2019. 5”The Greater Wealth Transfer”, Accenture, 2012.