As the weather becomes colder, now seems a good time to explore how ice is captured through time-lapse. Video sequences can speedily reveal its gradual changing state and magnify subtle changes. Ice in its various forms is fascinating to watch, and therefore it is interesting to focus on how it is captured in different ways, from ice cubes melting in a glass to ice crystals rapidly developing.
With such a variety of videos featuring ice, in this blog, we have picked out a selection of time-lapse videos that capture the different stages of ice close up. Not only are these interesting, but they also show how easy it is to get hands-on with a camera – often from the comfort of your own home.
Melting ice
Time-lapse photography is an ideal way to capture the mesmerising transition between water and ice. Even something so simple as watching ice melt can be appealing. There are numerous variations on this theme. This captivating amateur short time-lapse sequence reveals a solo ice cube rapidly melting.
Whilst a simple time-lapse capturing a glassful of ice cubes thawing fixes our attention.
Other time-lapse sequences speedily show the different states of water, from ice to liquid to boiling to evaporation.
On a larger scale, there is something fascinating about watching an intricate ice sculpture gradually dissolve into an unrecognisable state.
These often amateur time-lapses capture the straightforward melting of ice. Others mess around with the concept and disorientate the viewer. In the time-lapse sequence, Unmelt, Tony Round plays around with the melting of ice and snow to create this rather unsettling timelapse where the process is played in reverse.
Adding further interest to the concept of melting he has also created a video “Ice Storm” where items frozen during an ice storm in Toronto thaw out on timelapse. We witness them unfurling from their frozen mass to their former state, and to add to the interest he also flips this process throughout the film.
Ice forming in time-lapse
Other time-lapse videos focus on the sequence of water turning into ice. Just a glass of water gradually solidifying into ice is fascinating.
Whilst the beautiful yet simple “Frostylapse” time-lapses frost and ice crystals forming on a window. Each clip is 4 to 7 hours of real-time freezing, showing the exquisite formations of frost and ice crystals. The ice crystals subtly change colour throughout filming as light and conditions differ and the types of crystals and formation speed vary with temperature. When all the clips are edited together it creates a mesmerising time-lapse sequence.
Another unusual and intriguing video is of a bubble freezing. This amateur time-lapse reveals how frost gradually coats the delicate structure.
The enthralling short time-lapse film “Shifting Time – Water and Ice” by Daniel Kelly Brown is shot in natural surrounds and focuses on multiple day-long ice formations in Colorado rivers. It captures icicles growing from freezing water, as ice crystals form the crystalline structures.
Macro and micro time-lapse
Daniel Kelly Brown also produced his “Water and Ice” video in a macro version. Having produced the original version in 4K HD, he was able to zoom in to show the growth of the ice formation in further detail.
Macro time-lapse reveals footage that is not normally visible to the naked eye. A macro lens can magnify the intricate developments of frozen matter or capture a carpet of ice crystals creeping across the screen. In this macro time-lapse video, the footage reveals moisture from the surrounding atmosphere condensing at sub-zero temperatures to almost immediately form growing dendritic ice crystals.
Whilst using specialist equipment, microscopic time-lapse can chart the detailed formation of individual ice crystals. Filmed through a microscope, this time-lapse “Snowtime” by Vyacheslav Ivanov shows the intimate details of fragile snowflakes as they form in their miraculous hexagonal forms.
Why use time-lapse?
Time-lapse manipulates time, speeding up and emphasising changes to dramatic effect. Time-lapse captures the melting or creation of ice by piecing together all its different states to effectively show its many forms in just a short video.