Design Your Own Experiments With PSLab
PSLab, with its simple and open architecture allows programmers, hobbyists to use the tool for various measurements and to develop new experiments with simple python code.
One of the main target group, the PSLab is aimed at, is high-school science teachers and students, who may or may-not be familiar with the computer programming. For such users it is difficult to design or develop new experiments on their own. They may also find it difficult to fetch the data and plot required graphs, if a ready-made GUI is not available for that particular experiment.
To enable such users to quickly design a simple experiment for studying various phenomena, we have developed a simple Experiment Designer GUI. This incorporates few controls, read-back elements and easy functions to select parameters and plot graphs.
The screen shot of the ‘Design Your Own Experiment’ GUI along with the App-window is here..
Experiment Designer allows the user to define the control and read-back sequences of parameters and execute them.
Features of “Design Your Own Experiment” GUI
- Configure Experiment : Here user can select the required channels ( manual / sweep / read-back). One can also add a derived channel for measuring some physical quantity, for example ‘current’.
- Make Measurements : Selected channels are displayed. User can make measurements individually for each step or can sweep in auto mode.
- Plot and View Plots: Enables user to plot selected parameters. Acquired plots can be selectively displayed or deleted.
- Save Plots: Data acquired can be save in a spreadsheet.
- Save Profile : Experiment profile can be saved for repeating the experiment in future. Saved profiles can be loaded from “Load Profile” tab.
Example : Diode IV Characteristics Experiment
For this experiment one needs the following…
- A variable voltage source : Needs to be swept from Voltage A to B (say from 0V to 5V)
- Current Monitoring : Needs to be read for every value of Voltage
- Plotting and analytics : Tools to plot the parameters and save data
Schematic Circuit diagram:
CH3 monitors the voltage drop across the diode. PV1 is varied in steps, and for each step the current is calculated from the difference between voltages at PV1 and CH3, and the known value of the resistor. For example for 1K resistor, current through the diode is given by
I = (PV1-CH3)/1K
Procedure :
Step 1. Connect Fossasia PSLab to the pc. Connect the components – Diode from CH3 to Ground and 1k resistor from PV1 to CH3
Step 2. From the terminal Run
Experiments
The App-window will pop-up. Click on ‘Design your own Experiment’ button to get the experiment designer GUI.
Step 3: Select channels
Sweep Channel PV1 – Sweep from 0.00V -5.00V in 200 steps
Read-back Channel CH3 – for monitoring voltage across the diode
Derived Channel – To measure Current. Type the equation to calculate the current, (PV1()-CH3())/1000
Step 4. Click on ‘Prepare Experiment‘ to get measurements screen. Click on ‘Evaluate All Rows‘ to make the measurements.
Step 5. Select the required columns and click on ‘Plot Selected Columns‘, a message window will pop-up, here user can select the Axes for plotting the graph. On clicking ‘Plot‘, view plots screen will be displayed.
One can repeat the experiment and plot multiple curves and save them in a spreadsheet. Acquired plots can be selectively displayed or deleted.
Step 6. The entire design ( Experiment Profile) of the experiment can be saved for repeating the experiment in future. Saved profiles can be loaded from “Load Profile” tab.
This is a very important value add to PSLab Apps. It has enabled PSLab to reach out and help users, who do not have any background in programming. Now ‘designing your own experiments’ has become super easy 🙂 🙂 🙂
