Sometimes, missing teeth can cause the jawbone to atrophy over an extended period of time. The area of the jaw where teeth are missing gets “reabsorbed,” which leads to a decrease in both the quantity and quality of the bone, making bone grafting necessary.
The problem happens when dental implants are required to fix those missing teeth. When the jawbone has degenerated, patients aren’t good candidates for dental implants—yet. Bone grafting can make dental implants possible by replacing missing bone and even promoting brand new bone growth. The bone grafting procedure allows for dental implants by ensuring the jawbone has enough length and width, and even lets dental surgeons fully restore both aesthetics and functionality.
Minor vs. Major Bone Grafting
Patients may need a little or a lot of bone grafting, depending on the degree of damage. Injuries or gum disease can both cause varying amounts of degeneration and in some cases, even previous implant sites can be repaired with grafting. To get the bone for grafting, a patient’s own bone may be used (usually from the hip or tibia) or it may come from a tissue bank.
Sometimes sinus bone grafting is necessary, if the posterior upper jaw has degenerated. In some instances special membranes might be used, and these dissolve beneath the gum in order to safeguard the bone graft while regeneration takes place—this is called guided tissue regeneration or guided bone regeneration. Your dental team will discuss the best bone grafting options for you during a consultation.
Usually, major bone grafting is necessary when there are jaw defects. This could be caused by trauma, congenital birth defects or a tumor surgery. Most of the time, these grafts use your own bone that is harvested from the hip, tibia or even the skull.
What Happens with Bone Grafting Surgery?
When a ridge augmentation is necessary, a bone graft is placed on the tooth socket. This is usually done right after a tooth extraction so that a second procedures isn’t required. The gum tissue is then put over the socket and anchored with sutures.
Drs. Partridge and Maxfield might opt for a space-maintainer over the graft in order to achieve the original width and height prior to the tooth extraction or bone loss. This is where new bone will soon grow. When the socket heals, the alveolar ridge is prepped for an implant. Ridge augmentation is relatively simple, safe and done with local anesthesia in-office. Sedative medication may be available at the patient’s request.
Is a Sinus Lift for You?
Tucked behind cheeks, and above the upper teeth, are the maxillary sinuses. Empty and filled with air, pieces of the upper teeth roots go into these sinuses. However, when upper teeth are extracted, what’s left is a fragile wall of bone as the sole separator between the mouth and maxillary sinus. Patients need dental implants to hold the new, artificial teeth in place and these implants require bone. If there’s been any bone loss from trauma or periodontal disease, sinus augmentation can “lift” the floor of the sinuses to let new bone grow.
You might be a good candidate for a sinus lift if you’re missing two or more teeth in the back of your jaw, missing a lot of bone in the back of the jaw, the majority of maxillary teeth or have missing teeth from trauma or birth defects, and need dental implants.
During sinus lift surgery, a tiny incision is made along the molar or premolar region to access the jawbone during a sinus lift. Then, a minute opening is created in the bone while the membrane lining is pushed up. Below the space, the bone grafting materials are placed—this material comes from your body or a cadaver’s. At times, a synthetic material may be used. Once the bone is implanted, incisions are sutured up and healing can start. Several months later, the bone will eventually start to become one with the graft. At this point, implants can be placed on this newly stable sinus bone.
The Socket Preservation Procedure
Sometimes a tooth extraction is required due to an infection, fracture, pain or related bone loss. The “socket” is the bone that keeps your teeth in place, and it may get damaged from an infection, disease or deformity in the jaw after a tooth extraction. When a tooth is removed, the neighboring gum and bone can shrink quickly, causing defects such as sunken cheeks or collapsed lips. Not just unsightly, these defects can lead to big problems that may be fixed with restorative dentistry such as implants, bridges or dentures.
At times, these deformities from a tooth extraction may be preventable with “socket preservation.” This procedure not only improves smiles and appearance, but also sets up a patient for dental implants down the road.
There are many ways to preserve bone and reduce loss post-extraction. For example, sometimes the socket may be filled with a bone graft or an alternative substance. It’s then covered with your own gum or an artificial material, such as tissue, that helps stimulate proteins that repair the socket. In this case, the healing prevents collapse and shrinkage. The new bone is a solid foundation for future implants.