What’s a good NPS score? Have you found yourself here because you’ve just done an NPS survey and aren’t sure how to interpret your results? NPS surveys can be like chess; they’re easy to execute, but there are layers of complexity once you learn how to play the game.
In this article, we’ll unpack how to calculate your score, how you should compare it to industry benchmarks, and then examine how you can refine your analysis.
How do I calculate my NPS score for my mobile app?
Let’s start with a quick flyby of the basics.
Here’s the traditional NPS question:
On a scale of 0–10, how likely is it that you would recommend our product to a friend or colleague?
Your respondents fall into three categories:
- Promoters: answered 9–10
- Passives: answered 7–8
- Detractors: answered 0–6
Your final score will fall inside the range of -100 to 100. You get your score by subtracting the percentage of demoters from the percentage of promoters.
If your score is positive, that means you have more promoters than detractors. If your score is negative, then you have more detractors than promoters.
Here it is:
NPS = % of Promoters – % of Detractors
It’s a simple formula, especially given that it purposely leaves out passives, who have no direct measurable effect on your brand’s reputation.
If you’re using Instabug, this will be calculated for you automatically on your survey results tab.
Got your score? Now let’s see what it means.
What’s considered a “good” NPS score for my mobile app?
Short answer: it’s all relative.
For most cases, if it’s above zero, then it’s “good.” But how good that is widely varies by industry and context.
Let’s start with 0. Zero is a purely neutral score, indicating you’ve got the same number of people who are happy versus unhappy.
From zero to 30 is what’s generally considered to be a safe zone, neither poor nor exceptional. Some industries peak in this area. It’s a pretty average place to be. If you’re in this range, you can find ways to improve.
Score above 30, and we’re talking about companies that consistently make their customers happy, and are good at it. Their Promoters outweigh their Detractors by far.
If you have an NPS over 70, you’re a star. These companies are customer experience champions. They have devoted and talkative fans who will actively try to recruit new ones. Their promoters are basically volunteer brand ambassadors, who spread the word of mouth enthusiastically.
What are industry benchmarks for NPS scores?
Over two-thirds of Fortune 1000 companies use NPS. So where do you fit in?
We’ve republished the scores from this year’s US Consumer Benchmarks Report from Satmetrix.
Public averages can be good for a quick check-in to see where you’re at, but take this info with a grain of salt. Specific context can have an effect on scores; for example, some entire regions vote more conservatively than others. There are trends across industries as well, as shown below.
Average NPS by Industry (U.S. figures, 2019)
As you can see, the average NPS distribution across industries is all over the place, and (mostly) in the above-zero range. The average NPS in the software industry was 31 in 2018, well into the “good” zone. But cable TV and internet service providers slump far below neutral. These are examples of industries where getting a negative NPS score might not be a terrible thing—it might be extremely average. Even if you’re fitting in with industry standards, it’s still a sign that you’ve got some work to do.
Ultimately, where comparisons are concerned, industry benchmarks are only the beginning. Because the goalposts for greatness vary based on industry, location, language, and more, the most well-rounded analysis you can get is by doing a holistic competitive analysis that sizes up the competition from all angles. Your NPS score is just one item in your toolbox when it comes to finding out how you measure up.
Using in-app NPS surveys to collect better feedback
There are layers of depth to executing the perfect NPS survey: targeting the right people, asking at the right time, asking contextually in the right place, and following up properly. Instabug will help you accomplish your goals from start to finish.
NPS is attractive for being a simple, quantitative measurement that lets you know where you stand with your clientele and your competition. But that number only scratches the surface, and there’s more you can do with the Net Promoter System.
Some of the most important information you can take from NPS isn’t even the score itself. If you’re sending in-app surveys with Instabug, you’ll see an option for a second question: What can we do better? These answers will be some of the most valuable data you’ll get from your entire NPS survey. Backing up your numbers with qualitative answers will give you more context about what’s happening and what you need to do to create a more successful app.
Create custom questions and follow-up actions for NPS surveys using Instabug.
Instabug’s NPS survey options pack a lot of extra functionality into the world’s most popular customer satisfaction survey. You can customize the wording of your questions, request additional feedback, add thank you messages, and choose follow-up actions. Route promoters to the app stores to leave you positive reviews while requesting additional information from passives and detractors. Reach out and communicate with dissatisfied users by sending individual replies to survey respondents.
Learn