Any trade show that spans the better part of a week and nearly two million square feet of space will, by definition, be about a lot of things.
But as I walked the floor, watched the discussions, listened to the keynotes and scanned the announcements at this year’s International CES in Las Vegas, a handful of themes stood out. Here are the highlights and lowlights, the promising and surprising, and the disappointing and ridiculous things I noticed:
- CES this year was about thin laptops and big smartphones, high resolution TVs and high IQ appliances. It was about making devices prettier, like the HP Envy 14 Spectre and the Dell XPS 13. And it was about working to make gadgets easier to use by, among other things, replacing remotes, keyboards and mice with voice, touch and motion.
- It was a tale of two technology giants struggling to regain their glory after stumbling badly along the path to the mobile future. Microsoft and Intel took pains to demonstrate that they’re making the transition by highlighting the forthcoming Windows 8 operating system, HTC and Nokia smartphones running on Microsoft’s mobile software, and Lenovo and Motorola mobile devices powered by Intel chips.
- There were small things that solved real problems, like Griffin’s forthcoming mount for suspending your smartphone or e-reader from your upright and locked airline tray table, relieving passengers of the arm cramps that come with holding it up through a movie.
- We saw additional hints of how technology will become increasingly wearable and personal — or, to put it another way, how we’re slowly turning ourselves into cyborgs.
As my colleague pointed out, Innovega of Seattle was showing off efforts to develop contact lenses that can display images to the wearer, so your emails can pop up literally right before your eye and you can view the world through a layer of augmented reality.
Think Yelp reviews on the side of restaurants or the latest Tweet from the woman walking past you. Many of you will reflexively say, ‘no thanks, a line between personal technology and invasive technology has been definitively crossed!’ And you’ll be right.
- In some ways, CES this year was about where we’re going, rather than where we are. We were continually reminded that we’re on the precipice of some fundamental advances in technology. Carriers are rolling out zippy fourth generation wireless networks. Microsoft is bringing out an operating system with touch control on tablets and PCs. And a next generation of chips will offer big improvements in power and energy consumption.
These developments promise to bring about more fully realized versions of the ideas already at work in the ultrabooks, phones and TVs on display at CES. They’ll ultimately deliver smaller, thinner, faster, smarter, more intuitive, better integrated and ubiquitously-connected devices.
- We saw lots of power plays. The almost neurotic need for juice in our increasingly gadget-centric lives has spawned new product lines in their own right, like a bevy of battery cases for smartphones, wall socket converters with USB ports and even battery-equipped backpacks.
And now we come to the ‘as always’:
- As always, you couldn’t swing a LOLcat without hitting an iPhone cover at the show. They were tricked out with batteries, blinged out with jewels or equipped with bottle openers. They were waterproof, drop-proof or foolproof. And, for the most part, they were hideously ugly.
- As always, there were thousands of exhibitors on the show room floor insisting our headphones, TVs, laptops and smartphones that worked perfectly fine last month are now horribly antiquated and out of fashion.
- As always, those vendors employed hot women in embarrassingly scanty attire (otherwise known as booth babes) to lure dumb men to take a closer look at said gizmos. And in case that wasn’t enough, many used celebrities to draw eyes to products or people to events. LL Cool J, Snooki, Justin Timberlake and 50 Cent all made cameos this year. I won’t mention which products they endorsed — because it couldn’t matter less!
What does, however, is OMG I totally spotted Justin Bieber!
- As always, the symbiotic but unhealthy relationship between the tech industry and the tech media industry was on full display. They want us to pimp their products to strike deals and sell more units. We need to fill pages and blogs to satisfy an audience eager to hear what’s new.
It inevitably means that, collectively, we grant a level of attention to many products that is totally out of proportion to the value they might reasonably add to people’s lives. This week, it seemed no product was too silly, redundant or worthless for someone from somewhere to point a video camera at it.
And yet …
- CES also showcased how the mobile and Internet revolutions continue to change lives and commerce in meaningful ways, as the automotive, health care, entertainment, online, robotics and other industries all leverage apps, phones and tablets to invent new business models, better meet consumer needs and create new jobs.
Even as the economy remains in a funk for most industries, CES set a new record for exhibitors and nearly surpassed the all-time attendee mark.
- Finally, however, we also saw at the show how these unrivaled forces for growth and innovation face serious risks from the policy choices before us.
Sen. Ron Wyden (D-Ore.) took the stage to warn that the pendingStop Online Piracy Act and the Protect IP Act, aimed at confronting copyright infringement online, would deliver “a serious body blow” to the Internet.
Meanwhile, Federal Communications Commission Chairman Julius Genachowski sounded an alarm about the impending wireless spectrum crunch in the nation. Fittingly, he did so from a room where I couldn’t get an AT&T signal at all. Genachowski said we must address the problem soon and correctly, through among other things incentive auctions to free up underutilized capacity.
“At stake is U.S. leadership in mobile; at stake is a key platform for … harnessing technology to drive our economy,” he said.