Disagreements about money and finances are one of the leading causes of marital conflict and ultimately divorce in the U.S. Financial issues following a divorce can be equally devastating. Newly single moms are often left as the sole financial provider for themselves and their children.
Almost a decade ago, bankruptcy researcher Elizabeth Warren-- now Sen. Warren (D-Mass.) -- described one of the findings from her research into consumer bankruptcy in these terms: "Having a child is the single greatest predictor that a woman will end up in financial collapse."
There is a common misconception that people file bankruptcy at the drop of a dime or when they still have other options available to them. However, the reality is quite different. Some drain assets, such as their retirement accounts, which are protected from creditors in bankruptcy. Others continue to rely on predatory payday loans to make ends meet every month. In the end, this only causes you to fall further behind and have little to no money left to seek relief.
So how do you know as a single mom when is the right time to file bankruptcy? Here are a few questions to help you assess whether bankruptcy is a viable option after a divorce.
- Are you only making minimum payments on your credit cards?
- Are debt collectors calling you?
- Does the thought of organizing your finances cause stress and anxiety?
- Do you use credit cards to pay for necessities?
- Are you considering debt consolidation?
- Are you unsure about the amount you actually owe?
If you answered yes to two or more of these questions, it is time to take a closer look at your financial situation.
Begin by taking an inventory of all your liquid assets. Do not forget to include retirement accounts, stocks, bonds, real estate, vehicles, college savings accounts, and other non-bank account funds. Calculate a rough estimate for each.
Then, collect and calculate your bills and credit statements. If the value of your assets is less than the amount of debt you owe, declaring bankruptcy may be one way to get out from under your debt and get a fresh start.
Another sign that bankruptcy is a viable solution is if you are paying on your debts, and the balances are not going down. Perhaps they are going up. Bankruptcy experts say that if you cannot afford to pay off your debt in full over the next 36 months, you may want to consider bankruptcy.
There are many reasons people file for Chapter 7 bankruptcy. Some common reasons for filing for Chapter 7 are unemployment, unexpected medical bills or illness, overextended credit, and divorce. Chapter 7 is sometimes referred to as a "straight" or "liquidation" bankruptcy. Your assets are liquidated to pay off as much of your debts as possible. The cash from your assets is then distributed to your creditors. For many, Chapter 7 offers a quick, financial fresh start.
Chapter 7 bankruptcy wipes out many kinds of debt, including:
- Credit card debt
- Medical bills
- Personal loans
- Civil judgments (except for fraud)
- Past-due rent
- Past-due utility bills
- Business debts
- Some older tax debts
Some debts, including child support cannot be erased in bankruptcy. Student loan debt can be, but it is very rare, unless undue hardship is proven. But even if your most burdensome debt cannot be discharged, erasing other debts can give you the room you need to repay what you still owe.
If you are considering filing for bankruptcy, begin with these steps:
- Gather all necessary documents. This will document your income, your assets, and all of your debts. Download a copy of your FREE credit report to make sure you do not exclude anything. Put all of the relevant paperwork -- statements from all of your creditors, deeds and titles to property and vehicles, pay stubs, copies of tax returns -- into a folder.
- Find an attorney who is an expert in bankruptcy. If you have an attorney you have used before, ask him or her for a referral to a bankruptcy specialist. Do your research online and in person, do not be sold simply by an advertisement. Look at a firm's testimonials, past experiences with clients and the number of bankruptcy cases they have filed. With a good lawyer and the right information, filing for bankruptcy can give you the financial footing you need to get a fresh start.
It can be difficult to get credit right after bankruptcy. But a recent study on the effects of bankruptcy co-authored by Jaromir Nosal, assistant professor of economics at Boston College, show people who have completed bankruptcy are more likely to be granted new lines of credit within 18 months than people who fell 120 days or more overdue at the same time but did not file. That is why we advise debtors in over their heads to investigate bankruptcy, first.
Whether it is children, a disabled spouse, or an elderly parent, taking care of others financially in addition to trying to meet your own needs can quickly drain your money, time and resources. If you are struggling with debt and weighing your options, consider the number and the ages of the people who depend on you if the unexpected happens. The greater the number, the greater the need for an emergency fund, health insurance, and saving for their education.
If you are a single mom and considering filing for bankruptcy, contact an experienced Miami bankruptcy attorney who can advise you of all your options. Following a divorce, sorting through the emotional and financial devastation can take its toll, but know that you are not alone. Since 1996 Kingcade & Garcia, P.A. has been helping people from all walks of life build a better tomorrow. Our attorneys help thousands of people every year take advantage of their rights under bankruptcy protection to restart, rebuild and recover.
Related Resources: