Frequently overlooked, static abdominal training, or "holding," may stimulate deeper muscle fibers and increase core strength. It's the job of core musculature to work as root muscles from which all human movement stems. The abdominals must contract statically (isometric) to anchor physical activity. Since it's the natural function of abdominals to support body weight, it's logical to train them in this fashion.
It's unfortunate that, although abdominals are comprised of four muscle layers, most of us focus on the layer that lies just below the surface of the skin, rectus abdominus. Known as the "six pack," this strip of muscle is trained for mostly aesthetics. Devotion to obtaining the ever elusive six pack may cause us to forget the function of strong abdominals, which is to provide torso stability, even for something as simple as standing up from a chair.
Three deeper layers of abs, external obliques, internal obliques and transverse abdominus, lie underneath the six pack. In addition to trunk flexion, the movement of sit ups and crunches, deep layers dictate rotational and lateral movements and aid in respiration. When all layers are strong and work in a coordinated effort to stabilize movement, you experience your core as a powerhouse from which all movement in sports, as well as daily function, is enhanced.
We're all familiar with basic ab exercises done lying flat on the back in a variety of patterns from lifts to twists. Among fitness experts, concerns of hip-flexor involvement and lower-back stress are prevalent pertaining to many abdominal exercises. Issues such as these are valid and complex, and will not be expanded upon here. Incorporating static abdominal exercises in your ab routine will not prompt greater concern with respect to this issue.
The Exercises
Static ab work can be experienced in several positions; a simple example is straight-arm push-up position, also known as plank. You may vary plank by trying the side version and allowing only one arm as support. If desired, add even more difficultly by extending one leg upward.
You might notice that exercises such as these require strength in the arms and shoulders. As your abs gain static strength, your body weight will seem lighter and your arms more able to base the position.
An analogy is to think of moving a bed. A box spring is easier to move, as opposed to a soft mattress. When you mimic the box spring and your body is tight, your arms feel more proficient in handling the weight.
Considering this, stay rigid in core muscles and if arms still feel weak think of the work as an opportunity to strengthen muscles here as well, and more importantly to create a "kinetic chain" of coordinated static contraction that originates in the abs and like a domino effect spreads to the chest, shoulders and arms.
The boat, the crow and the staff, all of which can be found as part of power yoga, Pilates, and/or functional training routines, are static positions that promote ultimate abdominal strength. Try these movements in a series, mixing the order periodically for variety.
Overall, remember that any movement that requires you to hold your own body weight steady requires static strength in abdominal muscles and will enhance core stability. Advanced versions of this principle are inversions such as handstand or headstand, both of which require supervision to learn if you don't already possess the skill.
Although static work is effective, you shouldn't abandon your old routine entirely. Rather, eliminate some exercises, making changes gradually. Work up to holding static positions for five seconds each.
Tips and Cautions
Static work may cause holding the breath; be mindful to keep breathing. High blood pressure patients should check with a physician before experimenting with these exercises. If you experience chronic wrist pain or weakness, wearing wrist supports will be helpful.
Monica Schmidt has a BS in exercise science. Contact her at 561-789-8080 or info@somethingyoga.com.
Discuss This Article