Guy Kawasaki became an inspiration to a generation of young entrepreneurs when he wrote the book The Art of the Start, which has become practically required reading for young Silicon Valley types. Recently released was Kawasaki's latest book, Enchantment: The Art of Changing Hearts, Minds, and Actions. Kawasaki sent me a copy of Enchantment, which describes how to bring about "a voluntary, enduring, and delightful change in other people."
His book got me wondering: Is it possible to "enchant" an acquirer into wanting to buy your company? Inc.com contributor John Warrillow sat down with Kawasaki to talk about building a valuable—sellable—company.
Is it possible to apply the lessons in your book to making potential acquirers fall so in love with your business that they want to buy it?
The goal of any company should be to enchant its customers. My sequence of events would be build a company with great products that is enchanting to customers, which would make it successful, which would make it attractive for acquisition, which is different than saying, "build a company that enchants acquirers." Call me naive, but I think acquirers like companies because customers like them.
So the first step is to have an enchanting product, and the second step is to enchant customers . . .
And the third step is to wait for the phone to ring. I believe companies are bought, not sold. Lots of entrepreneurs ask me, "How do we make people acquire us?" or "Do you know anyone in business development at Cisco, Google, Yahoo?" I keep telling them that you don't sell a company. Google and Apple are getting 50 calls a day saying, "We have a strategic client who would fit in well with your portfolio, and you should buy them." I don't think that ever works. I think a company decides they want to buy another particular company and they go buy it. But I don't think that company sells itself.?"
Call me romantic, but when you start a company, I don't think the primary motivation should be selling it. I think the primary motivation for starting a company should be to build a great company with great products. And one of the possible outcomes is being acquired.
However, if you and your co-founder are sitting around planning how to be bought, and you don't even have a product, that's just ass-backwards. I think you're doomed to failure because your priorities are wrong. You should be thinking about building a great company, not how to get bought.
I think the key is you make the company so successful, generating so much cash that you don't want to sell. And then the phone rings. Then you're in the driver's seat because you don't want to sell because things are going so well. So they have to make an offer that sucks your eyeballs out and that you can't resist.
Having said that, you need to avoid doing stupid things so that, when the phone call comes (from a potential acquirer), you don't blow it.
Like what?
A simple thing is your legal structure. Are you a normal corporation, or are you one of these weird offshore companies you set up because you got it in your brain that you're going to make so much money that you need some kind of Cayman Islands organization. Plus the paperwork and legal structure, and the corporate minutes are so totally weird. It's going to take (an acquirer) a lot of work to undo all that crap.
Okay, so avoid anything too exotic when it comes to legal structure. What else can you do to ensure you don't blow it when the call comes from a potential acquirer?
Avoid having unsophisticated shareholders who are going to stand in the way of the acquisition. You don't want a bunch of rich dentists blocking a sale because they didn't know what they were getting into. . . .
Okay, so have a simple legal and capital structure. What else do business owners need to do to avoid shooting themselves in the foot?
You need to clearly and cleanly own the intellectual property. For example, you want to avoid a situation where you work on your new business idea while simultaneously working for another company, because your employer could turn around and say they own the intellectual capital because you worked on it while you were on the job for them.
What else?
Your employees need to be happy and stick with you after the acquisition. I think it is important that the equity be spread so that it's not just you who owns 99 percent of the company and all of the other employees own 1 percent, so you're thrilled to be acquired but they look at it like, "We just got everything sold out from under us, and who knows if the acquirer is going to keep us or they're going to use their existing employees."
Are you suggesting you give stock or options to employees?
In technology, we definitely give stock options, not outright gifts. The clean deal is that your employees have stock options that they are vesting over 48 months with a one-year cliff. A cliff means that you get one-48th of your stock for 48 months, but you have to be there at least 12 months. So in other words, if you work there two months and you quit, you shouldn't get two-48ths. The company doesn't want a whole bunch of people with small amounts of shares out there, so a company will force their employees to be there at least a year to get options.
Is there anything else that can be done to make yourself irresistible to acquirers?
A clean capital structure, indisputable ownership over the intellectual capital, and motivated employees are the essentials. The real key, though, is that you have a great product that customers are buying.
John Warrillow is the author of Built To Sell: Creating a Business That Can Thrive Without You, which will be released by Portfolio/Penguin on April 28, 2011.