Still Struggling with Post-Cancer Loneliness?
Here’s the Secret to Putting It Behind You
by Debbie Woodbury
I’m OK with solitude. In fact, I crave it. What I’m not OK with is loneliness. Before my breast cancer diagnosis and mastectomy, I thought I knew what loneliness felt like.
The night I gave birth to my first child, I eagerly anticipated the joy of holding her in my arms. Instead, because my doctor feared that I had a virus, I was quarantined away from my baby girl until the next day. It was the loneliest night of my life … until I got cancer.
For the first six and a half months of diagnostic tests, doctor visits, and surgery, I was rarely alone in the trenches. Together, my family and I trudged through diagnosis, treatment, and re- cuperation. I fully expected survival to be a celebration.
It wasn’t. Instead, I was hit with the emotional fallout of living with cancer and was left standing in the rubble as my loved ones, convinced “the worst was over,” returned to normal without me. This wasn’t like the night apart from my newborn. Nor was it like the five long years of miscarriages and fertility struggles my husband and I endured to get to that night. We soldiered through those difficult experiences together, in solidarity. This time, it was just me, all alone and facing an in- escapable, unrecognizable “new normal.”
My salvation began two days after my mastectomy, when a breast cancer navigator walked into my hospital room and introduced me to the world of cancer support services. Desperate to crawl out of the black hole of loneliness, I committed to meeting weekly with a therapist. As I talked through all the grief, fear, anxiety, and trauma of my cancer experience, I learned that I wasn’t alone. I had a tribe. I was, and am, part of a massive community of cancer survivors.
Eventually, I gathered the courage to join support groups and attend a rehabilitation exercise class. It was in these group settings that I discovered the secret to putting my post-cancer loneliness behind me: connecting with other survivors.
With this discovery, I began having conversations with other survivors about what it’s like to feel alone in a crowd, how others often judge without understanding, and the difficulty of recovering emotionally while everyone around you wants to move on. Through commiserating with my fellow cancer survivors, I found the ladder I needed to climb out of the deep pit of loneliness.
As I look back, I realize that the solution to my post-cancer loneliness was simple. All I had to do was show up and allow myself to be supported. (Of course, that’s not to say that simple is synonymous with easy, especially when cancer has sapped you of the energy to put yourself out there.) Yet, the reward was worth the effort. Connecting with others who understood what I was going through vanquished my loneliness, and I was able to begin healing emotionally.
You are not doomed to live in the depths of post-treatment loneliness. Show up to support groups, make an appointment with a therapist, call cancer helplines, seek out mental health professionals, and connect with your fellow survivors. If you can muster the energy to put yourself out there, you will find the support you need to light your way out of the dark shadows of loneliness.
♦ ♦ ♦ ♦ ♦
Debbie Woodbury is a breast cancer survivor, motivational speaker, blogger, and author of the books You Can Thrive After Treatment and How to Build an Amazing Life After Treatment, which are available at amazon.com. You can keep up with Debbie on her blog at WhereWeGoNow.com, as well as on Twitter (@DebbieWWGN) and Facebook (WhereWeGoNow as Cancer Survivors).
This article was published in Coping® with Cancer magazine, September/October 2014.