Worldwide, politicians and policymakers lust after innovation, proclaiming it to be the ultimate solution to all economic maladies everywhere. Practically every country aspires to create its own Silicon Valley.
What a bad idea.
Not only is Silicon Valley pretty muchimpossible to recreate as an innovation eco-system, it’s also no longer the only global paradigm for innovation. The world has changed — drastically. But our understanding of how innovation works, and who benefits, has failed to change with it.
Production of goods and services is now globally fragmented. Things are now produced in multiple stages across multiple locales orchestrated by vast global networks. The result has been an ever-increasing regional specialization in particular stages of production, rather than in entire products or industries.
This change is demonstrated by the recent, dramatic rise of global interfirm (not just intrafirm) trade in components and services. Not only our smartphones but also all their major components were developed, designed, produced, and assembled in more countries than most Americans will visit in their lifetimes.
The implication of these changes is that it is no longer clear to what degree the economic-growth benefits of an innovation remain in its birthplace. The global reorganization of production and services has produced a new logic of value creation, as well as a new set of specialization and innovative capacities. No longer can one country excel at all stages of product development and production. Therefore, we must rethink what innovation-based growth means and what the best strategies for investment might be.
INSIGHT CENTER
Leading InnovationSPONSORED BY ACCENTURESet your organization on a path toward powerful new ideas.
When each country is specializing in a different stage of production, each country needs to excel in a different set of innovations. At least as important is the fact that each such specialization leads to a different distribution of the economic fruits of success.
Silicon Valley grew to prominence after World War II by being the place where entrepreneurs developed new ideas and turned them into mass-produced goods and services. Innovation and production were done together, if not by the same firm, then at least within the United States (think about it — the production of silicon chips gave the region its nickname). Companies like Apple, Seagate, Hewlett-Packard, and Intel created significant numbers of new, well-paid jobs, all within the borders of the U.S.
Today the situation could not be more different. Silicon-chip fabrication is no longer Silicon Valley’s strength. Instead, the Valley has specialized in being a global source of innovative ideas. Production and the growth of new industries around these ideas occursinternationally, across fragmented manufacturing networks.
A major beneficiary of these global changes has been Taiwan, which became a global leader in semiconductors during the 1990s. Indeed, Taiwan is now the place for high-end silicon-chip fabrication. Many of Silicon Valley’s semiconductor start-ups now hope that one of two Taiwanese companies — TSMC or UMC — would be willing to fabricate their chips for them. But that is not the only global niche Taiwan controls. Many of our favorite electronic gadgets were designed and built by Taiwanese companies, which often act like contract manufacturers for inventions created by firms elsewhere, such as in Silicon Valley.
Taiwanese companies need to constantly innovate to maintain their position on top of the manufacturing heap. They know that the minute they fall behind their competitors, the best Silicon Valley companies will stop choosing them as their preferred partners in production and fabrication. So they need to continually improve — in fact, they have to be every bit as innovative as Silicon Valley’s entrepreneurs, but with a different goal. Instead of trying to come up with the next blue-sky idea, Taiwan’s entrepreneurs focus on production and design improvements that will allow them to turn American start-ups’ ideas into physical reality faster than competitors and at ever-falling prices.
This is a very different system, utilizing very different business models, than the romantic ideals we invoke when we talk about innovation-based growth. Nonetheless, Taiwanese society has enjoyed tremendous, and broadly shared, economic growth, which is based on its firms’ ability to continuously innovate in the latest high-technology sectors, while supplying large numbers of good jobs to people with different sets of skills.
Most of Silicon Valley’s start-ups, by contrast, are lean, with relatively small staffs. The Valley’s elite engineers, designers, developers, and financiers may have great jobs, but with production fragmented globally, excellence in invention and discovery — in the earliest steps of the innovation process — doesn’t guarantee sustained or widespread economic growth.
The decomposition of production means that there are multiple ways for countries to achieve sustainable innovation-based growth. This should come as wonderful news to policy makers, because it means they no longer have to be slaves to a foreign economic model that will never work in their countries.
First, each nation needs to figure out which phase or phases of innovation it wants to support. This is not a simple decision. It should be based on which kinds of activities best fit the country’s capabilities. It should also be based on national economic goals: If the aim is continuous creation of good jobs for as many citizens as possible, then focusing only on invention might be the worst possible strategy. Countless studies have shown that most of the growth resulting from innovation happens in the next stages, when products and services are being produced, refined, developed, and sold. In order to generate economic growth, inventions and discoveries need to be transformed into products and services sold on the free market.
Second, having chosen an innovational phase to excel in, a country needs to figure out which forms of investment will best further its goal. Which institutions, financial regulations, and educational systems are needed to support the capabilities it aspires to develop? And if its current innovation efforts aren’t generating enough local economic growth, what can be done to remedy that situation? The U.S., for example, must devise new innovation policies that mesh its strengths in novel-product innovation with downstream capacities that will lead to economic growth within the country.
Taiwan does a great job of demonstrating the feasibility of using innovation to generate tremendous, and broadly shared, economic growth. It’s a very different model than Silicon Valley’s, but it also embodies the benefits of the knowledge economy.
Source: