by Julie Wan
Predicting Flash Floods The Front Range, part of the Rocky Mountains in Colorado, is prone to flash flooding because of steep surfaces and the heavy summer rains it experiences. Recently the National Center for Atmospheric Research (NCAR) has been testing a new forecasting system that aims to give specific flash flood warnings at least 30 minutes and possibly even 1 to 2 hours before the event. It is difficult to predict when flash floods will occur because they are so sudden. Although radar can detect heavy rain, it is hard to say whether a storm will stall over a particular area or what specific water source a flood is going to hit. These events depend on a number of factors, including soil and topographic and hydrologic features of the area. The new system provides a synthesis of information on both land and atmosphere, taking both surface conditions and hydrology into account. NCAR scientist David Yates said that the system is “unique in that it provides a detailed forecast of the location and duration of a severe storm, as well as the watershed’s likely response to the heavy rain. Since flash floods are complex and fast-moving events, we need to know about both weather and ground conditions in order to predict them.” Funded by the National Science Foundation and NOAA, the system uses radar detection from the National Weather Service and short-term computerized forecasts generated by NCAR’s Weather Research and Forecasting model, which simulates local atmospheric conditions in great detail. The new system will enable scientists to forecast the occurrence of flash floods for both particular streams as well as larger areas and to issue advance warning to those who will be affected. Thunderstorms Linked to Asthma A recent study by researchers from the University of Georgia and Emory University found that the number of hospital visits for asthma-related problems in the Atlanta area increased after thunderstorms. While numerous studies have documented the link between asthma and thunderstorms, this is the first conducted in the Southeastern United States, where thunderstorms and asthma are common. The study, published in the online edition of the medical journal Thorax, examined hospital data from 20 counties in the Atlanta region from 1993 to 2004. It also used data on thunderstorms, total daily rainfall, and maximum five-second wind gusts from Atlanta’s Hartsfield-Jackson International Airport. From more than 10 million emergency room visit records, the team found a 3 percent increase in visits for asthma on days after a thunderstorm. Researchers speculate that asthma hospitalizations increase following thunderstorms because pollen grains rupture when they come into contact with rainwater, which releases allergens that are then scattered by strong winds during the storm. Lead author Andrew Grundstein, a climatologist in the Department of Geography at the University of Georgia, said, “While a 3-percent increase in risk may seem modest, asthma is quite prevalent in Atlanta, and a modest relative increase could have a significant public health impact for a region with more than 5 million people.” Stefanie Ebelt Sarnat of Emory added, “Obtaining a better understanding of the mechanistic basis of the phenomenon of thunderstorm-induced asthma will allow for better intervention strategies and improved emergencies services planning.” Understanding Lightning Researchers at the University of Florida (UF) and the Florida Institute of Technology (FIT) recently were able to use electric field and X-ray detectors to search for the source of X-rays generated by lightning. Their goal is to be able to predict where lightning will strike. The researchers showed that as lightning moves from cloud to ground, the X-rays are emitted at the beginning of each step leader, which is the path of ionized air that creates a return storke channel. “Nobody understands how lightning makes X-rays,” said Martin Uman, a professor of electrical and computer engineering, adding, “it’s obviously happening. And we have put limits on how it’s happening and where it’s happening.” In 2002, UF/FIT researchers showed that the negatively charged leader is what produces the X-rays. In the most recent study, UF/FIT researchers further narrowed the source of X-rays down to the beginning of each step in the step leader. Understanding how lightning moves is key to one day making predictions about lightning strikes. The possibility could help researchers develop better lightning protection systems. “A spark that begins inside a thunderstorm somehow manages to travel many miles to the ground, where it can hurt people and damage property,” said Joseph Dwyer, a professor in the Department of Physics and Space Sciences at FIT. He added, “Now, for the first time, we can actually detect lightning moving toward the ground using X-rays. So just as medical X-rays provide doctors with a clearer view inside patients, X-rays allow us to probe parts of the lightning that are otherwise very difficult to measure.” The study was published in the online edition of the American Geophysical Union’s Geophysical Research Letters. No More April Showers Could the American Southwest get any hotter and drier? It could and already is, say researchers from the University of Arizona (UA) in Tucson. In a study published in the American Geophysical Union’s Geophysical Research Letters, the researchers write that the northward shift of the westerly winds is bringing less rain and snow in the springtime. The researchers compared the month-to-month winter storm track, temperature, and precipitation records for the western United States as well as pressure at different levels of the atmosphere from 1978 to 1998. They found that changes in late-winter precipitation in the western United States are related to changes in the storm track path. “We used to have this season from October to April where we had a chance for a storm. Now it’s from October to March,” said Stephanie A. McAfee, a doctoral candidate in the UA’s department of geosciences. The study is the first to make this connection between the poleward movement of the storm track—which has been documented for decades—and the changing storm pattern in the Southwest. The occurrence affects Southern California, Arizona, Nevada, Utah, western Colorado, and western New Mexico. “During the period it’s raining less, it also tends to be warmer than it used to be,” said McAfee. Researchers fear the earlier occurrence of heat and dryness will have an impact on snowpack, hydrological processes, and water resources. Blame Ike In a strange case of a hurricane actually improving someone’s life instead of causing destruction and sorrow, Marlow Wayne Reynolds has Ike to thank for a brief stint of freedom he experienced in early September. Reynolds, who received a 40-year term for murder and several other charges in 2004, escaped from prison in Brazoria, Texas, on September 9, just days before Hurricane Ike hit the region. While residents were evacuating and authorities were focused on the hurricane, Reynolds managed to stay on the run for three weeks. With the help of several witnesses, he was finally found hiding in the woods near the San Bernard River and captured on September 28.