In iiko, stock list items are products (or goods), menu items (items), prepared components (or semi-finished products), modifiers, and services. To open a complete stock list, go to Inventory management > Stock list.
Use Inventory management items to access corresponding inventory units. The services are separated from this list and are given as a special reference in the Finances section.
Each type of inventory (stock list items) has a special icon:
Products are foodstuffs (flour, sugar, potato) used to cook menu items, modifiers, and semi-finished products, or ready-to-eat items (chocolate, coca-cola, bottled water) that are purchased and sold as is.
Items are meals that are cooked to a recipe and served to guests. An item consists of ingredients and has a recipe. Like clam chowder, Caesar salad or coleslaw.
Modifiers are menu item options or additives like condiments. For instance, Steak has several modifiers for doneness and ice-cream may have various toppings. A modifier may have a recipe and consist of ingredients.
Prepared components are pre-prepared foodstuffs or semi-finished products consisting of ingredients and used in cooking. For instance, peeled potato, dough, grated cheese.
Services and rates are services you or your contractors provide to your guests, e.g., pool, delivery, rent.
Groups are categories used to unite similar stock list items. A group may contain not only items but other groups as well.
Depending on whether a stock list item has a recipe or whether it is on sale, it takes an additional icon:
A stock list may have a tree view or table view which you can choose in the View menu. The icons are shown under the tree view.
Item properties are given in columns and can be shown or hidden. For this, click View and check the Columns settings item opposite the columns you are interested in.
Suppose a cost accountant creates a detailed recipe and can control the markup using the following indicators:
Use the reference book to run reports on the nutritional and energy value of items. For this, in the Actions menu, select the required report.
On the right-hand side of the window, hover the cursor over the Outlets tab to see the pop-up table. It provides prices set in the chain outlets according to the basic price change orders.
You can create a new order from the reference book window. For this, select the required items or groups using the Ctrl key and click the Price change order shortcut menu item. If you select a stock list group or groups, all items in these groups will be included in the new order.
The stock balance information is only available to users with the “View inventory reports” permission (B_VSR).
This article covers basic stock list operations: copying, moving, editing, deleting and recovering. For how to create and set up a group, product, item, etc., refer to the Stock List Group and Stock List Item articles.
To quickly find a stock list item, enter its name in the Search bar.
Search results are displayed in different ways subject to the reference book view:
Sometimes its easier to copy existing items rather than to create new ones. Select an item that is similar to the one you want to create and click Actions > Copy. This opens a new item page where fields are populated the same way as they are in the source item except for the Name, Stock list code, and Quick code. Fill up these fields manually and click Save and Close.
You can move stock list items from one group to another. There are three ways to do it:
Use this feature to edit several stock list items at a time. You don’t have to open each page one by one. For this, press and hold Ctrl or Shift, select the required items, and click Actions > Edit. The Edit stock list items window pops up.
Here fields are populated with the values that selected items share. An empty field means that selected items do not have the same value in this field or it wasn’t set at all.
If you want all the items to have the same parameter in a particular field, specify the required value in this field and click Save.
A list of modifiers can be set up on the item’s page. It’s easy to edit items with the same modifiers as a group. For this, select items by pressing and holding Ctrl or Shift and click Actions > Edit modifiers.
If selected items have different modifiers, this window shows all of the modifiers rather than only matching ones.
The For all field shows whether this modifier is shared by all items ‒ , by some items ‒ , and by no items ‒ . To delete a modifier in all selected items, uncheck the For all field and click Save.
If all items have the number of modifiers restricted in the same manner, this table shows the value. If those values are not the same, the fields are empty.
To set the same number of modifiers for all the items, enter the value in the empty field. If you leave it blank, existing values will be used.
To add a simple or group modifier to all items, click Add and select the required modifier as described in the Modifiers article.
You can remove any item from the reference book. For this, select the required items on the list and click Actions > Delete.
If you try to delete items that have a non-zero stock balance, the program will show a warning:
In reference books, reports, and documents, deleted items are stricken through. Reports and documents always show deleted items, and their quantities and prices are included in calculations.
To see deleted items, click View > Show deleted.
You can always restore deleted items. For this: