Fritz Lang’s 1921 film Der müde Tod comes to cinemas and Blu-Ray this week. Fiona Pleasance makes a date with Death.
Der müde Tod is an early flourish by one of the great German filmmakers, Fritz Lang. The title literally means “weary Death”, but at the time the movie was released in English-language territories as Destiny or Beyond the Wall. It was the film which brought Lang international attention, and was made immediately prior to one of the greatest directorial runs in cinema history. In the following 12 years he not only made the German Expressionist classics Dr Mabuse The Gambler (Parts One and Two), Die Niebelungen (Parts One and Two) and Metropolis, but also Spies, Woman in the Moon, M and The Testament of Dr. Mabuse. After this last film was banned by the Nazis in the spring of 1933, Lang left Germany for France; he ended up in Hollywood a couple of years later.
If Der müde Tod is not currently as well-known as most of those other films, that may be about to change. The Murnau-Stiftung, continuing their sterling work maintaining the German cinematic legacy, completed a digital restoration of Der müde Tod in 2016: collating various extant copies, recreating and adding intertitles, and tinting and toning the final image according to contemporary conventions. This version of the film is being released in the UK this week, on disc by Eureka under their Masters of Cinema banner, and in selected cinemas. UK filmgoers will now be able to enjoy the work cited by Hitchcock and Buñuel as a formative influence in a quality approaching that of the original release.
Lang wrote the screenplay with his regular collaborator and wife, Thea von Harbou. A young couple encounter a mysterious stranger on their way to a small town. There, the stranger purchases a plot of land next to the town cemetery and erects a wall around it. The couple meet him again at the local tavern, and the young woman leaves the room briefly. When she returns, the stranger and her fiancé have disappeared.
The stranger is, of course, Death himself, who has withdrawn to the town because he’s getting rather fed up with all this dying business and would like a bit of peace and quiet. After the woman begs him to return her fiancé, Death offers her three chances to save him. The lovers will appear in three different scenarios from human history: an Arabian Nights-type setting, Renaissance Venice and ancient China. If she manages to save her fiancé just once, Death will return him to the land of the living.
The film then goes a bit Cloud Atlas and transposes the actors from one scenario to the next. It appears that the couple have no memory of their situation, but the character played by Death still catches up with them in every life, although the characters directly responsible for their problems are played by different actors. Ultimately, the film returns to the framing story, and Death and the young woman resolve the issue.
If Der müde Tod has a weakness, it is a certain unevenness of tone. The uncanny and Expressionist elements of the framing story are somewhat undermined by a bit of satire; not only are high-ranking members of the town’s authorities gently mocked, but it is suggested that even Death shouldn’t always take himself quite so seriously. At times it feels as though Lang is attempting, but not entirely succeeding, to channel Lubitsch.
Each of the three different scenarios then plays out in a different register: largely dramatic for the Arabian and Venetian stories, mainly comic for the Chinese segment. For the modern viewer, not quite knowing how to respond to what’s on screen will possibly be heightened by the – from today’s perspective – implicit racism on display in both oriental stories. This was probably mild by the standards of the time but occasionally makes for uncomfortable viewing nonetheless. (Actually, Thea von Harbou was responsible for quite a bit of the Orientalism in German cinema in the early 1920s).
These reservations aside, Der müde Tod has much to recommend it. The acting is excellent, particularly Lil Dagover’s tenacious young lover and Bernhard Goetzke’s gaunt Death, whose exhaustion is written in his eyes. But many of the supporting performances are equally enjoyable, especially – as so often – Lang’s frequent collaborator Rudolf Klein-Rogge, who threatens to steal every scene in which he appears (in the Arabian and Venetian stories).
And the visuals are frequently stunning, the different eras created with style and attention to detail; even the intertitles change according to the different settings. If the film doesn’t strictly qualify as Expressionist, there’s no escaping those tendencies, particularly in the make-up and sets, the lighting and composition. Der müde Tod also contains many excellent examples of one of the great strengths of German film production in the 1920s, namely the creation of optical illusions and special effects. In fact, so impressed with the movie was Douglas Fairbanks – at that time one of the biggest movie stars in the world – that he bought the US distribution rights and promptly failed to release it.
Destiny didn’t enter US cinemas until mid-1924, by which time Fairbanks had been able to copy a good many of the effects, including its flying carpet, for his newest release, The Thief of Bagdad.
Full disclosure: when I saw this film last year, it was at screening in a church with a live accompaniment on the church organ. The orchestral score, newly composed and recorded for this release, can’t really hope to match that for appropriateness, but is a fine alternative.
Der müde Tod [Destiny], from the Eureka ‘Masters of Cinema’ series, is released in the UK on Dual Format Blu-ray / DVD on 9th June 2017. The disc includes a 2k digital restoration of the film with a new score plus several extras. The film is also being shown at selected cinemas around the country.