I put the pads on when I was 9 years old and would have played football in high school if I'd been eligible. I appreciate the game. The excitement of it. The intensity of the battles. The drama of a tight 4th quarter. And the way it tests young men's strength, will, and determination in their struggle against pain and gravity and aggression. I appreciate the coaching battles. The strategic nuances. And I appreciate football's place in our culture -- the Friday battles of high school, the Saturday showdowns in the NCAA, and the Sunday clashes of the NFL. Wars fought on grass and turf. School against school. City against city. Wars in which no one has to die -- except that people are dying from playing football, a relatively small number during the game and many not so long after years of playing, more of them than we used to realize -- enough to make me relieved that I wasn't eligible to play for my high school.
A number of recent articles, books, and television documentaries (including the recent, PBS Frontline, League of Denial have shined the spotlight on new research about head trauma and brain injuries and the toll taken on the lives of the boys and men who play football. The tragic stories of Junior Seau, Mike Webster, and others stand in for lesser known football players who suffer and often die prematurely in silence.
Not all scientists agree with the research and the NFL has been slow to acknowledge the extent of the dangers of its game, but there is enough evidence for at least parents and educators to be concerned.
And I cannot help wondering about high school football. I mean, should there even be high school football?
Just asking that question is probably an affront to players and their fans at every level. But I'm asking because the question needs to be asked.
Because don't we put student safety above all else?
It's why we take even the slightest threat of violence so seriously.
It's why we confiscate weapons and punish or expel those who carry them on campus.
It's why we try to make our high school campuses drug and alcohol free.
It's why we have prom buses and Grad Night and take other measures to keep our students from driving each other around drunk.
It's why we don't (or shouldn't, anyway) tolerate bullying.
Why we take our students' emotional health -- and any of their suicidal thoughts -- so seriously.
It's why, here in California, the earthquake safety standards for new school construction are so stringent.
It's why, as a matter of fact, high school athletic authorities require football pads and helmets to meet and be maintained to a high standard. It's why we have medics at football games. It's why we now have rules about how soon young men can play after a concussion and why many football coaches are required to be educated about concussions.
But new evidence suggests that so-called "sub-concussive" head trauma can also be destructive to mental health. And even if that evidence is less than conclusive -- and I'm not saying it isn't conclusive -- don't we usually err on the side of caution where our children are concerned? For example, if we think that maybe one of our students is the victim of child abuse we are required by law to call the authorities. If we think that maybe a student has brought a weapon to school, we search that student. If there is a shooting five blocks from our school, we're probably going to have a lockdown.
This troubles? But it also troubles me because I understand the value of high school sports -- as motivating and character-building and community-building activities. I understand that in the part of Los Angeles where I teach and coach, high school football is, among other things, a gang-prevention program.
So if lives are at stake from the risks of football then they may also be at stake if high schools stop playing it.
And, yes, there are injuries in almost all sports but in every other high school sports the serious injuries are accidents and mishaps. In football, head-to-head combat -- and all the short- and long-term consequences -- are a natural part of the game played the way it is intended to be played. Leading with one's head is effective. It is cheered. And, according to what neuro-scientists are now saying, it is potentially and ultimately deadly.
Perhaps the game of football in general and high school football in particular can be made safer. Perhaps it already has been -- with all the elevated awareness about concussions and head-trauma -- but I don't believe anyone can say, with certainty, that we are not putting all those young men playing the sport at risk. We really don't know if the game is just inherently too violent.
The National Football League may never sincerely act in the long-term interests of its players, all of whom are consenting adults (though they all started playing long before they were). But high schools -- many of which prohibit skateboarding on campus for safety reasons! -- have a moral obligation to put student safety above all other considerations.
If playing football has a high risk of long-term permanent brain damage, how can any education institutions -- high school or, for that matter, college -- allow its students, whose minds have been entrusted to us, to subject themselves to such damage in the name of those institutions?
Illustration by Carly Strauss.