A woman jogs along the Charles River on an early spring evening in Boston. (Reuters)
Getting regular moderate or vigorous exercise may offset some of the potentially lethal health effects of regular alcohol consumption, a new study suggests.
Researchers confirmed an increased risk of death from alcohol-related cancers as well as death from all causes among those who drank more than just occasionally, compared to people who never imbibed. But the elevated risk diminished or disappeared if drinkers exercised regularly.
"Alcohol is the most commonly consumed psychotropic drug that, in contrast to most other drugs, is socially and culturally acceptable," said senior author Emmanuel Stamatakis, an associate professor of exercise, health and physical activity at the University of Sydney in Australia.
"Alcohol consumption is high, and there are no signs that this will change," he told Reuters Health by email. "We need to find ways to reduce some of the health risks associated with drinking."
Nearly 90 percent of Americans report drinking alcohol during their lifetimes, and more than half of adults say they have consumed alcohol in the past month, according to the Centers for Disease Control and Prevention (CDC). More than half of American adults also get no exercise, according to CDC.
Previous studies have linked alcohol use with increased risk for certain cancers, as well as heart disease, liver disease and several mental health conditions, the study team writes in the British Journal of Sports Medicine. However, there is little research investigating whether positive health behaviors, such as physical activity or diet, might offset the long-term risks of alcohol use.
The researchers analyzed data on 36,000 men and women over age 40 who took part in the annual Health Survey for England or the Scottish Health Survey in the 1990s and 2000s.
Participants were grouped into six categories: Never consumed alcohol, ex-drinker, occasional drinker, or drinks more than occasionally but within current guidelines (less than 14 standard UK drink units - equivalent to 8 standard U.S. drinks - per week for women and less than 21 UK units or 12 U.S. standard drinks for men). The final two categories were "hazardous" drinking (14 to 35 UK units per week for women or 21 to 49 units for men) and "harmful" drinking (any more than "hazardous").
Researchers also categorized weekly exercise in terms of metabolic equivalents of task (METs), a measure of energy expended. An average of 7.5 MET-hours per week, for example, translates roughly to a little over two hours of brisk walking at 3 miles per hour.
After adjusting for other factors including age, race, sex, weight, social class, smoking and other diseases, researchers found that people drinking within guidelines and getting little or no exercise were 16 percent more likely than people who never drank to die of any cause during the course of the study, and 47 percent more likely to die of cancer. "Hazardous" drinkers had similar risks as those within guidelines, and "harmful" drinking carried a 58 percent higher risk of death from all causes and an 87 percent higher risk of death from cancer.
At 7.5 MET-hours per week, people drinking within guidelines had about the same risk of all-cause mortality as those who never drank and 11 percent higher risk of cancer death. Hazardous drinkers had 18 percent higher risk of all-cause mortality and 9 percent higher risk of cancer death.
With 15 MET-hours of exercise per week, drinkers within guidelines had 10 percent to 20 percent lower risk of death compared to never-drinkers, and even harmful drinkers had about the same risk of death from cancer as never-drinkers and just 13 percent higher risk of all-cause mortality. At all exercise levels, "harmful" drinking still carried significantly elevated death risk.
Benefits of exercise include reduced inflammation and improved immunity, the study team writes, while alcohol has the opposite effect.
"There are few things that make humans look better, feel better, be more productive and live a longer and better quality life," Stamatakis said. "For people who don't do any physical activity, starting with 10-minute walks every week and building to 30 minutes per day is a great first step."
"This study suggests what science tells us broadly with respect to alcohol and exercise," said Tim Naimi, an associate professor at Boston University, who was not involved with the research.
"At the end of the day, the less people drink, the better," he said. "And the more people exercise, the better."
"This is about reducing the consequences," Naimi added. "Unlike our genes, which we can't control, we can make better choices about exercise and drinking that can improve our health in the long run."