Historic Engines – Stanley Steamer
The idea of a car powered by a steam engine sounds really strange, doesn’t it? Who would even think of building something like that? You would have to start the car’s boiler about 15 minutes before you could even think about driving anywhere, and there are all those knobs and valves to use – how complicated would that car be? Furthermore, why are we including the Stanley steam engine in this series on historic automobile engines?
To answer those questions, we called up Jay Leno – probably the foremost enthusiast and collector of steam-powered cars in the world today.
“Steam engines were actually quite reliable back in the day,” Leno says. “The advantages were no clutch, no transmission, no choke, no magneto, and no hand-cranking that could possibly spit back and break your arm. Steam engines tend to run forever because they’re not under any stress.”
The Steam Engine in Context
Forget for a moment that you live in the 21st century, and imagine you’re back in 1910. The gasoline engine was first invented in the late 1800s, maybe 20 years ago, and you’ve only been seeing gas-powered cars on the street for 5 years or so. Henry Ford has just released the Model T in 1908, and even that will run on alcohol, kerosene, or gasoline, because there’s no general agreement that gasoline will be the fuel that everyone’s going to use. Even Detroit Electric is making some pretty cool electric cars that are as good as anything else on the road.
But, on the other hand, you’ve been riding in steam trains your whole life. Your grandfather rode around with steam engines, and you see them all over the place. You know about steam technology and you understand it, so you trust it. And here’s the kicker: the steam-powered car is by far the fastest and most powerful vehicle you can buy.
While most gasoline-powered cars were putting along at a maximum of 25 miles per hour, a steam-powered car could easily hit triple digits. To give you an example, Fred Marriott set the world land speed record of 127.659 mph in a specialized Stanley Steamer in 1906. In 1907 he was very close to raising his own record above 140 mph, but he lost control and crashed the car while trying.
Just to be clear, that Steamer was going faster than most modern cars can go, over 110 years ago. Be impressed.
How a Steam Engine Works
Leno explains it like this: “With a Stanley, every stroke is a power stroke, so a two-cylinder steam engine has the same power impulses as a V8. A four-cylinder has the same power impulses as a V16. You’ve got all kinds of power, and it’s so different from an internal combustion engine. They’re a lot of fun to drive.”
As Leno says, there are actually two chambers in every cylinder on the Stanley steam engine. So the piston gets pushed in alternating directions as the engine rotates. That’s why even though the Stanley engine makes only 10-30 horsepower, it makes up to 800 pound-feet of torque. That’s enough to twist the tires off the wheels, which is why the Stanley could out-accelerate anything else on the road in 1910.
Here’s another reason why the Stanley Steam engine is cool: The whole thing had just 13 moving parts. The engine was connected directly to the rear axle, so there’s no transmission. It takes some practice to learn the function of every valve and control on the Stanley Steamer, but once you get the hang of it the car is quite drivable in modern traffic.
The engine itself is really two parts. There’s a boiler and the actual engine. The boiler burns kerosene or gasoline and boils a little bit of water at a time. The steam is then directed to the pistons to push them one way and then the other. As the pistons move, the steam on one side is released back into the condenser to become water again, and more steam enters in from the other direction to reverse the piston motion.
“It does take a good 15-20 minutes to get one going,” Leno says. “It works very similar to a water heater. You light a pilot, and then you turn on the boiler and you get a big rush of steam.”
One major misconception that people have is that a steam engine is likely to explode. “People think they blow up, but no Stanley Steamer has ever blown up,” Leno advises. It can’t blow up just by the nature of the way the steam boilers are built. They have copper in them, so the copper will melt and burst and blow steam in the air, but they don’t blow up.”
Stanley Steamers Today
Stanley made steam-powered cars for 25 years, from 1901 to 1924. In that time the company made and sold about 9,500 cars. By 1924 the gas engine was really dominant and people had pretty much settled on the standard control layout for cars. But in the first quarter of the 20th century, other steam car manufacturers such as White and Doble also flourished.
You could buy a Stanley Steamer runabout for as little as $850 (about $20,000 in today’s dollars) in 1910, but most models cost about twice that much. Today, you can find working Stanley Steamers in good condition at around $50,000, but some have sold as high as $200,000.
If you’re interested in learning more about steam cars and seeing them in action, you can watch several episodes of Jay Leno’s Garage online where Jay details everything you ever wanted to know about steam-powered cars. These episodes are well worth your time to watch.