Workplace Drug Testing
By William J. Judge, JD, LL.M.
Park-Dickens Group
For the past 20 years the perception has been when conducting private workplace drug and alcohol testing that the best thing to do was to follow federal DOT rules. But, due to the many changes in state law, "mirroring" DOT rules in your non-regulated drug testing program can get you into trouble. You must follow the rules that apply. A recent court decision in Minnesota makes this abundantly clear.
On November 5, 2008, a federal district court in Minnesota found in favor of an employee who, despite having his first positive drug test and contrary to state law, was fired. The Court appeared so upset with those who fired him that the court took the rare step of allowing the fired employee to amend his complaint to ask for punitive damages. The Court said:
Although [the manager] was aware that [the employee] was off work because he was in drug treatment, she did not consider [the Minn. state law] in deciding to fire him. Indeed, [the manager] was unaware that [a state law] existed. Notwithstanding the fact that she was responsible for ING's employees in Minnesota, [the manager] ignored the section of ING's employee manual discussing Minnesota's [law] because she personally was a Delaware employee.
Further, . . . superiors in the IT department did not consider whether [state law] limited ING's ability to fire [the employee]. [The] immediate supervisor, knew nothing about [the state law] and had only a vague understanding of ING's corporate drug-testing policy. ***
In short, there is no evidence in the record that any of those who were actually or potentially involved in deciding to fire [the employee] gave a moment's thought to [state law], despite the fact that ING's employee manual contains a section on [state law].¹
Today, with every drug test situation (who to test, split or no split, medical review or no medical review, terminate or not, etc.) we must ask: "What Rules Apply?"
In years past it may have been OK to mirror federal rules, but today things have changed. Just over 22 years ago, workplace drug testing got its "big start" when President Reagan issued Executive Order 125634², requiring each federal agency to establish a substance abuse prevention program, including drug testing. In 1987 HHS/NIDA (now SAMHSA) issued its Mandatory Guidelines and in 1988 DOT issued its rules. In 1989 the United States Supreme Court, for the first time, addressed and upheld the concept of workplace drug testing.
Since then the focus of the drug-test industry and employers has been on "federal" rules. (Either SAMHSA or DOT). But, unless the test is federally mandated that focus is misdirected. Since the mid-1980s there have been over 7,000 court cases issued and more than 550 state laws passed that impact workplace drug testing.
As it relates directly to what MROs (Medical Review Officers) do there are:
- 21 states that require non-regulated employers to medically review results
- 3 states have times for contacting an MRO different than federal rules
- 1 state (OR) requires the MRO to report a positive result to a state agency
On other issues that affect MRO’s employer-customers:
- 12 states have alcohol cut-off levels different than DOT
- 15 states require all collections to be split
- 8 states require a retest of a positive result
- 21 states specifically define or prohibit³ post-accident tests
- 30 states specifically define "specimen"
- 19 states require written notice of a positive result
- 14 states require posting notice of a policy
These are only some of the many examples of state law issues that MROs and their customer-employers must know to avoid litigation and loss. Other peculiarities include one state that requires retest cutoff levels to be that same as initial confirmation levels; one state that limits employee contribution to the cost of split analysis to be no more than the employer paid for the original test; one state that requires the employer to pay for the cost of the split analysis; 3 states that require collectors to register with the state and pay a fee; states that prohibit observed collections and states that require proof of training for instant test administrators.
As you consider these issues keep in mind that 16 states make it a crime or authorize civil penalties for failure to follow state rules.So, before you act, please ask: What Rules Apply?
Footnotes
¹WEHLAGE v. ING BANK, FSB, d/b/a/ ING DIRECT, Case No. 07-CV-1852 (PJS/RLE) UNITED STATES DISTRICT COURT FOR THE DISTRICT OF MINNESOTA 2008 U.S. Dist. LEXIS 90249 November 5, 2008.
²51 Fed. Reg 180 (September 17, 1986) states in part as follows:
The head of each Executive agency shall develop a plan for achieving the objective of a drug-free workplace with due consideration of the rights of the government, the employee, and the general public. * * * (b) Each agency plan shall include: * * *
(5) Provision for identifying illegal drug users, including testing on a controlled and carefully monitored basis in accordance with this Order.
³CT, RI and VT only permit tests based on reasonable suspicion.
William J. Judge, JD, LL.M., is Director of Research for Park-Dickens Group. Visit them online at. For more information, please e-mail the center at info@fightreadynow.com or contact them toll free at 866-328-7487.