In 2003, the photographer Edward Burtynsky had a modest exhibit in Washington at the Embassy of Canada, offering a sampling of his large, color photographs of industrial sites. Burtynsky’s images were striking, and immediately memorable, for their unnerving mix of menace and beauty: gracefully swooping piles of discarded tires, unnaturally vertiginous quarry walls, and ochre-hued rivulets of nickel tailings.
The photographer explained in the accompanying catalog that, growing up 20 miles northwest of Buffalo, N.Y., he arrived a century too late to experience nature that was “pristine” or “sublime,” so his art gravitated toward images of heavy-industrial settings in the United States and his native Canada. The uneasy balance between environmental destruction and visual splendor was plain to see, yet his work’s matter-of-fact approach and lack of overt judgment lent the exhibit a winning understatedness.
Six years on, Burtynsky’s international renown has only grown, and his ambitions have demonstrably snowballed.
In the catalogue to his current exhibition, “Edward Burtynsky: Oil,” at the Corcoran Gallery of Art, he explains that “all the vast man-altered landscapes I had pursued for over 20 years had been made possible by the discovery of oil and the progress occasioned by the internal combustion engine,” and that the spent more than 12 years researching and photographing “the largest oil fields I could find.” He went on “to make images of refineries, freeway interchanges, automobile plants and the scrap industry resulting from the recycling of cars. I began to look at motor culture, where vast tribes come together with vehicles as the main attraction.”
In other words, oil, for Burtynsky, is the grand unification theory, and while his imagery continues to dwell fruitfully on the precipice between grandeur and doom, his work has acquired a not-so-winning sense of overreach. (And self-importance: The bulky, 200-plus-page catalog for his current exhibit sports the rather epic title “Burtynsky: Oil” and retails for $125, twice the price of his 2003 catalog).
In seeking to trace the vast international reach of petroleum, Burtynsky seems to have ignored the reality that his best work has always been tightly constructed. With this exhibition, Burtynsky proves that while he is a master chronicler of place, he is considerably less successful as a chronicler of ideas.
Burtynsky’s finest work in this exhibit consists of his depiction of the surreal landscapes of oil extraction. His double-wide panoramas of oil derricks such as Oil Fields #19 a and b, recede to the California desert horizon and spill headlong out of the frame. They are eye-opening in every sense of the word. His prints offer a bracing combination of massive scale, fine detail, and mesmerizing color—and that’s before you even start to unpack the subject matter, which is equal parts resonant and otherworldly. In the catalog, Corcoran curator Paul Roth aptly calls the rigs “great mechanical mosquitoes…desiccating their surroundings in service of an unlimited thirst.”
Equally impressive are Burtynsky’s images of decrepit, disused oil fields in Azerbaijan. Here, the derricks are even spindlier and more insect-like than the ones in California, and the environmental devastation is more stark: rusting metal facilities, detritus-strewn mud, and highly reflective pools of impenetrable blackness. Even the one element that outwardly seems “clean” is a forceful spray of liquid arcing into the muck from a broken pipe, undeterred (and seemingly unwatched) by any human intervention.
Also notable are Burtynsky’s images of places where waste products go either to rot or to be recycled. These range from compacted (“densified”) assemblages of cast-off oil filters to unexpectedly poetic piles of “bushling” scrap metal; an ochre patina lends Ferrous Bushling #18 the incongruous look of fall foliage. Meanwhile, Burtynsky’s visit to low-tech recycling concerns in the poorer corners of South Asia yielded a powerfully iconic image that is surprisingly underplayed in the exhibit: a footprint-shaped blot of oil.
But if Burtynsky is at his best when he visits places the average person does not know exists, this hardly describes the other images in the show, especially those intended to chronicle America’s “motor culture.”
Did you know that Los Angeles sprawls? That Interstate on-ramps sometimes agglomerate into something resembling a spaghetti bowl? That developers like to build clusters of Spanish-tile-roofed mini-mansions in the Sun Belt? That lots of people enjoy attending NASCAR events? That Sturgis, S.D., draws motorcycle fans for a big conclave every summer? Each of these topics is somehow deemed worthy of the Burtynsky treatment, yet none of the resulting images inspires even a flicker of enlightenment: The scenes are simply too familiar, too well-trod by artists. (I’ll take Ed Ruscha’s aerial photographs of parking lots any day over Burtynsky’s—and Ruscha’s are more than four decades old.)
Instead of spreading his work too thin in the service of a grandiose goal, Burtynsky would have done better to focus on a few key places and provide some in-depth context. The exhibit offers only minimal explanations of what’s going on in the images we’re seeing, yet the photographs document fascinating and largely untold stories of great import. Canada’s Alberta oil sands, for instance, have exploitable reserves the size of Florida—and environmental problems to match. Seeing the photographs of Alberta in the exhibit, you know something’s amiss, but there’s no way to know exactly what. For a photographer as talented and perceptive as Burtynsky, this failure to fully communicate can only be described as a missed opportunity.