Willie's "Getting the Most out of DB2 for z/OS and System z" blog.
Patrick Bossman, who works on the DB2 for z/OS Query Optimization team at IBM Silicon Valley Lab, put together a "guest" blog post for me. With an expectation of a lot of customers migrating to DB2 9 for z/OS in 2009, he wanted to get this information out to everyone.
There has been some question regarding what is IBM's recommendation regarding REBINDs when customers migrate to DB2 9. Since we're talking about REBIND, we're referring to static SQL. Our recommendation and rationale is listed below. 1) The purpose of conversion mode* (CM) is to work out any issues during a phase when fallback to the previous release is available. We are not recommending fallback at the first hint of a problem - but that it is desirable to discover problems while fallback is available if it's necessary.
* Note: CM was referred to as compatibility mode in DB2 Version 8
Recommendation: It is recommended that customers do rebind in DB2 9 CM. 2) Following up on the principle established in #1. There are some changes to RUNSTATS.
New histogram statistics to improve filter factor estimation for range predicates when the literal values are known. New CLUSTERRATIOF algorithm. New statistic called DATAREPEATFACTOR (also known as DRF) which measures density of underlying data for each index.
Histograms are a "column based" statistic - they can be collected or not. The new CLUSTERRATIOF and DATAREPEATFACTOR improve DB2's ability to differentiate indexes by allowing DB2 better recognition of the true sequential nature of data and the density of data according to a particular index. So the customer will not fully experience DB2 9 optimization until after they've performed a RUNSTATS on all of their indexes and performed a REBIND. Recommendation: It is recommended that customers perform RUNSTATS + REBIND on their packages before converting to DB2 9 new function mode (NFM). 3) DB2 9 introduces a new feature called access path stability. With this feature enabled and used, DB2 will REBIND to generate a new access path and also preserve the previous (BASIC) or both the previous and the original (EXTENDED) versions of the runtime structures / access path. The design point is - access path stability provides access path recovery capabilities. If the customer performs a REBIND using access path stability and the performance for a package suffers, the customer can perform a REBIND SWITCH PREVIOUS or REBIND SWITCH ORIGINAL to restore the previous/original runtime structures and access path. Access path stability can be controlled at the subsystem level by DSNZPARM PLANMGMT in macro DSN6SPRM, which then impacts all package REBINDs, or at the individual REBIND statement level with REBIND parameter PLANMGMT. Recommendation: Our strong recommendation is to use access path stability because it provides a very quick and easy restore of the previous access path. Customers have had COPY / RECOVER capabilities for their data for many years. We hope customers will also take advantage of DB2's ability to backup and recover previous access path / runtime structures in the event there's a performance regression on a few packages. We recognize that customers may be constrained on catalog / directory space required to store multiple versions on the runtime execution structures (which are the execution instructions implementing the chosen access path). With this in mind, we provide three alternatives here..
For more information on Access Path Stability, please see: Documentation on access path stability
Roger Miller access path stability article
Final clarifications:.
I hope you find the above useful. If you do, let us know and I'll get Pat to do some more writing for us in the future. Well, that's it for now. Don't forget to check out Anthony's blog (my Grandson) at And as always, thank you for stopping by and thanks for your continued support
Thanks,
Rick Creech "