The Fiduciary Rule Is Under Review — How Will This Affect Your Investments?
If you have money invested in a retirement plan, such as a 401K or an IRA, chances are high you'll be impacted by an executive order issued recently by President Trump.
It centers on the "fiduciary rule," one of former President Obama's initiatives that was scheduled to go into effect on April 10th. President Trump put the brakes on it by ordering the Labor Department to study the issue further.
Whether the rule goes into effect or not, you would be wise to understand what all the fuss is about and how it could affect you.
Fiduci…What?
Financial professionals, such as financial planners, insurance agents, brokers, and others, are legally bound to adhere to certain standards of conduct, the highest of which is a fiduciary standard. Anyone working under that standard, which today includes Certified Financial Planners and Registered Investment Advisers, is required to act in their clients' best interests, detail all commissions and fees, and disclose any potential conflicts of interest.
Others, including many brokers and life insurance agents, are held only to a suitability standard. That means if two financial products could meet a client's needs, but one would pay the financial adviser a higher commission, he or she could recommend that product to their client.
The Obama administration estimated that biased advice steering people to needlessly high-cost, high-commission financial products and services costs investors $17 billion per year in fees and lost investment income. Its fiduciary rule would require any financial professional recommending retirement-related financial products or services to adhere to a fiduciary standard.
What It Means for You
Here are some steps you can take to help make sure your retirement accounts are run in your best interest, rather than the managers'.
If you participate in a 401K, 403(b), or other workplace retirement plan, ask questions about how your investment options were selected. Some plans have a very limited set of choices or offer mutual funds with high fees. In particular, take a look at the "expense ratio" tied to the funds. That's the percentage of the money you invest in the fund that goes toward the expenses of operating the fund. For example, if you buy shares of a fund with an expense ratio of 0.73%, for every $1,000 you invest, $7.30 will go toward the fund's operating expenses. (See also: Watch Out for These Sneaky 401K Fees)
According to Morningstar, the average expense ratio is .78% for an actively-managed mutual fund and .18% for a passively-managed (index) fund. If the funds in your plan are significantly higher than that, ask your plan administrator to explain why.
Find out if any of the companies behind the funds in your plan participate in "revenue sharing agreements" in which they pay to be part of your plan. Often, these are higher-fee funds.
A good resource is Bright Scope, an independent evaluator of workplace retirement plans. See if it has evaluated your employer's plan, and if so, see what it says about the fees charged by your plan.
Employees at some companies have even sued their workplace retirement plans over what they felt were needlessly high-cost investment options. In 2015, the U.S. Supreme Court gave employees the right to do so.
If you work with a financial planner, insurance agent, or other financial professional, ask whether the person you work with adheres to a fiduciary standard. As awkward as it may be, ask about the commissions or other compensation they receive from the products or services you purchase through them. Before committing to working with someone, interview a couple of others and compare costs.
Three Situations That Warrant Extra Caution
Be especially careful about deferred annuities, mutual funds with a "front-end load," and 401K "rollovers." In each situation, you may be especially vulnerable to receiving biased advice. (See also: 3-Step Plan to Choosing a Mutual Fund)
With deferred annuities, you invest now in order to receive a stream of income in your later years. Deferred annuities usually provide salespeople with high commissions and come with especially onerous surrender charges if you decide to cancel your contract. Be very cautious. Generally, the type of annuity that makes the most sense is an immediate fixed annuity purchased around the time of retirement, and even then only with a portion of your nest egg. If someone is recommending an annuity for you and retirement is far down the road, at very least, ask lots of questions about fees, commissions, and surrender charges. And carefully weigh the comparative advantages of investing in mutual funds outside of an annuity instead.
Some financial advisers exchange their advice for the commissions they receive by recommending mutual funds with front-end loads, or sales fees. If you put $1,000 into a mutual fund with a 5% front-end load, that means you've lost $50 right out of the gate. At a time when there are countless no-load funds available, including target-date funds that automate some of the most important steps an adviser would do for you (such as, determine and then manage your asset allocation), it's difficult to imagine a situation where it would make sense to pay such fees. (See also: Commission Free ETFs: A Great Option for Cost Conscious Investors)
When you leave your employer — whether for retirement or to move on to another company — plenty of brokers would love to have you rollover your 401K money into an IRA at their firm. Such rollovers often do make sense because an IRA will give you more investment options. Just be sure to ask questions. Are there account fees? Is investment advice available to you from a fiduciary adviser? Compare the costs and services of at least three brokers.
Bottom Line
No matter what happens with the fiduciary rule, it's in your best interests to require all financial professionals you seek advice from to adhere to a fiduciary standard. At very least, they should fully and clearly disclose any fees, commissions, and potential conflicts of.