For those patients still on AndroGel 1%, you should know that there is a more concentrated version available—AndroGel 1.62%. If you're interested in using less gel, talk to your doctor about AndroGel 1.62% today. If you'd like more information on AndroGel 1%, just read on below and then discuss with your doctor.
AndroGel 1% is a controlled substance (CIII) available by prescription, used to treat adult men with low or no testosterone. It is a daily testosterone replacement therapy (TRT) that can raise low testosterone levels with daily use. The testosterone in AndroGel 1% is the same as the testosterone that your body makes naturally. And, when used daily, it can help you raise your T levels.
AndroGel 1% is clear, odorless, and quick-drying. And it offers packaging options in the form of a metered-dose pump or packets, so you and your doctor can choose what works best for you.
It is important to note:
AndroGel 1% can transfer from your body to others. This can happen if other people come into contact with the area where the AndroGel 1% was applied. Signs of puberty that are not expected have happened in young children who were accidentally exposed to testosterone through skin-to-skin contact with men using topical testosterone products like AndroGel 1%. Women and children should avoid contact with the unwashed or unclothed area where AndroGel 1% has been applied.
AndroGel 1% contains testosterone, which is absorbed through the skin after application. The testosterone in AndroGel 1% is the same as the testosterone your body makes naturally. It can help raise testosterone levels to the normal range in most men when used daily.
The most common side effects of AndroGel 1% are acne, skin irritation where the gel is applied, increased cholesterol levels, increased prostate specific antigen (a test used to screen for prostate cancer), increased red blood cell count, and increased liver function tests.
In a clinical study, of the 129 hypogonadal men who continued AndroGel 1% therapy for 6 months (with dose adjusted properly), 87% had their T levels restored to normal.
AndroGel 1% can cause serious side effects, including worsening symptoms of an enlarged prostate; possible increased risk of prostate cancer; lower sperm count; swelling of ankles, feet, or body; enlarged or painful breasts; problems breathing during sleep; and blood clots in the legs or lungs. Before you use AndroGel, tell your healthcare provider if you have breast cancer; prostate cancer; urinary problems due to enlarged prostate; heart, kidney, or liver problems; problems breathing while you sleep (sleep apnea); and/or have any other medical conditions.
AndroGel 1% is a topical testosterone replacement therapy. Since AndroGel 1% is a gel, there are a few things you should know about packaging and application before you begin treatment.
AndroGel 1% is available in a metered-dose pump and in packets. Our metered-dose pump contains enough gel for many uses. We also have pre-measured packets that contain enough gel for a single application for certain doses.
Your individual dosage may vary, so be sure to follow your doctor's instructions.
Whether you choose the pump or the packets, it is important that you understand the correct way to apply AndroGel 1%. Read below to find application information for both.
The AndroGel 1% metered-dose pump gives you the exact amount of medicine that your doctor has prescribed. Two pumps are included in your package of AndroGel 1%. If you are using the starting dose of AndroGel 1% (50 mg of testosterone in 5 grams of gel), this supply will last you 30 days.
Before using a new bottle of AndroGel 1% for the first time, you will need to prime the pump. To prime the AndroGel 1% pump, slowly push the pump all the way down 3 times. Do not use any AndroGel that came out while priming. Wash it down the sink or throw it in the trash to avoid accidental exposure to others. You do not have to prime your pump every day, only the first time you use it.
It is important that you apply AndroGel 1% exactly as your healthcare provider tells you to. Your doctor will tell you how much AndroGel 1% to apply. You can also check the label on your bottle to see how many times to press the pump for the dose your doctor has prescribed. It is important that you apply AndroGel 1% exactly as your healthcare provider tells you to.
Find your dose as prescribed by your physician
AndroGel 1% is also available in packets. Each packet contains 25 mg of testosterone in 2.5 g of gel or 50 mg of testosterone in 5 g of gel. After use, throw away the packet in the trash out of the reach of children to avoid accidental exposure.
Your healthcare provider may change your AndroGel 1% dose. Do not change your AndroGel 1% dose without talking to your healthcare provider.
AndroGel 1% is not meant for use in women.
When using AndroGel 1% it is important to note the following.
AndroGel 1% is flammable until dry. Let the gel dry before smoking or going near an open flame.
Avoid showering, swimming, or bathing for at least 5 hours after you apply AndroGel 1%.
Women and children should avoid contact with the unwashed or unclothed area where AndroGel 1% has been applied. If a woman or child makes contact with the AndroGel 1% application area, the contact area on the woman or child should be washed well with soap and water right away. Stop using AndroGel 1% and call your healthcare provider right away if you see any signs and symptoms of puberty in a child, or changes in body hair or increased acne in a woman, that may have occurred through accidental exposure to AndroGel 1%..