Premature Ovarian Failure / Infertility
Premature Ovarian Failure (POF)
The Florida Institute for Reproductive Medicine (FIRM) has extensive experience treating women with premature ovarian failure who want to get pregnant. Distinguishing POF from premature ovarian aging (POA) is important in that treatment strategies and prognoses will be very different.
What is Premature Ovarian Failure?
Premature ovarian failure is a loss of ovarian function before the age of 40. POF can affect women at various ages from the teens to the thirties. Women with POF are at greater risk for a range of hypoestrogenic health issues including osteoporosis, genitourinary atrophy, hot flashes, vaginal dryness and heart disease. These issues can usually be managed effectively with estrogen replacement. However, in an infertility context POF poses a challenge, as the loss of ovarian function means that the probability of pregnancy is greatly reduced. Although it is sometimes called early menopause, POF is different from menopause in that POF is not a result of the natural aging. Women with POF, in addition, may continue to have menstrual cycles, though their cycles will be irregular. A small percentage of women with POF can conceive naturally, while menopausal women will never get pregnant.
Diagnosis of Premature Ovarian Failure
Many patients with a diagnosis of POF actually don’t have POF – when tested many “POF” patients turn out to have
premature ovarian aging (POA). While these two conditions sound similar, distinguishing between POF and POA is important.
Women with POA can get pregnant. FIRM physicians have demonstrated, and reported pregnancies in women with even severe POA. For women with true POF chances of pregnancy with their own eggs is rare. The distinction between POA and POF is based on the maximum level of follicle-stimulating hormone (FSH). Patients with FSH levels above 40.0 mIU/mL, a post-menopausal level, are diagnosed with POF, while patients with elevated FSH levels that do not exceed this threshold are diagnosed with POA.
Causes of Premature Ovarian Failure
There are several known causes for premature ovarian failure: genetic conditions that affect the X chromosome (Turner Syndrome and Fragile X syndrome), autoimmunity (immunity against oneself), surgical loss of ovarian tissue, or loss of ovarian tissue due to chemotherapy and/or radiation.
Getting Pregnant with Premature Ovarian Failur
As already noted, pregnancy in women with POF is rare. The Florida Institute for Reproductive Medicine does offer treatments for POF patients – primarily for those with an immune or idiopathic cause. Patients with other causes of POF will be strongly encouraged to consider donor egg IVF. At the FIRM it is always the patient who decides on treatment.
Most POA patients will have a reasonable chance of pregnancy with their own eggs. FIRM’s success in treating POA patients is primarily based on the use of aggressive stimulation protocols, along with the use of growth hormone.
Unfortunately, growth hormone appears not to be effective at all in patients with POF. We have designed highly discounted multiple cycle IVF packages to allow patients to have repeated IVF transfers if necessary.
Premature Ovarian Failure and Pregnancy Through Egg Donation
In our opinion, nobody should enter an egg donation cycle without being absolutely convinced that it is their only realistic chance for pregnancy. We respect our patient’s desire to “try at least once” with their own eggs, if they feel they have a reasonable chance. At FIRM we feel it is our responsibility to make certain that our patients have accurate and comprehensive information when making these decisions. The patients ultimately must decide what represents a “reasonable” chance.
Egg donation is, undoubtedly, the most successful treatment for women with POF. With their own eggs, POF patients have a pregnancy chance, at most, in the low single digits. In FIRM’s egg donor program the same POF patient will have a cumulative pregnancy rate in the high 70-80s from a single egg donation cycle. Since embryo’s quality is largely derived from the egg, and egg donors are typically young (ours all in their 20s), recipients of donated eggs will have the same pregnancy chances and miscarriage rates as a woman in her 20’s.
Predicting Premature Ovarian Failure
If a patient has a first degree relative, mother, maternal aunt or sister who went through an early menopause or who is already experiencing lengthening cycles, occasional hot flashes or extended periods of amenorrhea – ovarian reserve testing should be offered immediately. Fertility preservation, whether through ovarian tissue cryopreservation, egg freezing or preembryo freezing should be considered along with regular ovarian reserve testing.