What you can expect when you hire Echo Video
October 31st 2013
For a company who hasn’t used a video production company before the process can be daunting so in this blog I’m going to run through what you can expect during a typical video production process when you hire Echo Video.
Meeting
After we receive your initial enquiry we will contact you to organise a phone call or a time to meet and talk over coffee (or tea). We can then go through your project in as much detail as possible so we can give you an accurate, free, no obligation quote.
Pre-Production
Once you have accepted the quote we will move into the pre-production phase. This includes the following –
- Script writing – You know your product/service the best so we work closely with you here in order to produce a clear, interesting and engaging script that really gets your key points across.
- Actors/employees – depending on the type of video you want we can source actors or if the video is a selection of interviews we can take lead from you about which employees or customers will appear in the video.
- Location – We can bring all the required equipment to your office if there is enough space or we can organise studio space anywhere in the world. We can also travel to external sites such as construction sites, factories and scenic locations across the world.
- Equipment & crew – Once we have arranged all of the above we can then decide on the best equipment and crew to use, keeping the final video and budget constraints in mind.
Production
After the pre-production is complete and you are happy with the plans we will then move in to the production phase. This is where all the filming takes place and we have a few tricks to help the people on camera relax, especially if this is the first time they have done anything like this –
- Once we arrive on set whether that’s a studio or your office we will get set-up as quickly as possible in order to avoid disrupting your day. This will generally include lights, camera and sound.
- We will have a run through/rehearsal if the video is particularly complicated or simply meet everyone that is involved.
- If we are interviewing a selection of people we try not to let them rely too heavily on a script. The reason for this is if they are nervous and they keep forgetting the lines then their performance may suffer as they try to remember. We’ve found that having a simple conversation based on a number of questions helps calm the nerves and in the editing process we can piece the story together. If an exact script is necessary then nothing can beat practice and being prepared.
- On set we don’t tend to use video production jargon such as ‘camera rolling’, ‘action’ and ‘cut’ because we have found it can heighten nervousness and seem a bit alien, so we like to keep it simple and use everyday language.
- If an interviewee or a presenter makes a mistake it really doesn’t matter as we can re-do it until it’s right. If the person in front of the camera is really struggling we have been known to say we aren’t filming even though we are and that usually results in a near perfect shot.
Post Production
Once all the shots have been gathered we shut ourselves in our studio in Hove and begin editing. This is where the video comes to life and we can manipulate the footage in many ways to help tell the story clearly and in an interesting way. We can be as creative as you want us to be and you can have as much or as little input as you wish. Some of clients like to sit in on the edit and others let us get on with it whilst following the process via our secure client login area on our website. Below is the general process we follow –
- We first of all put a ‘rough cut’ together which contains the raw footage and the bare bones of the story. You can then look at this to make sure the story and message is right.
- Once we know we are on the right track we will then tighten the edit to it runs seamlessly and add in graphics, animations and titles if required.
- After this we source appropriate music and get the voiceover recorded. The reason we leave the voiceover until now is so that it can be precise as possible to the video and if there are any unclear bits in the interview(s) the voiceover can elaborate on them.
- After all this is done and you are happy with it we will then colour correct the footage if required and grade it as well. The point of this is to help the video appear seamless by making sure all the shots match and a colour grade can help tell the story by introducing different moods through the use of colour.
Delivery
Once you are happy with the final video we then move in to the final stage. This is where we make the video available in different formats depending on where you want to use it. Here are the three most common ones –
- Online video sharing sites – We will compress the video to the best format for websites such as YouTube and Vimeo.
- DVDs – The process of putting a video onto a DVD is known as DVD authoring and this involves compressing the video in to a specific format and creating menus so the viewer can watch a particular section of a video or a whole video. Just like your favourite film you watch at home on DVD.
- Blu-ray – This is the same process as DVDs but it means you can watch your video in high definition if you have the right hardware.
This has been a general guide and no two projects are ever the same but hopefully it has given you an insight in to the video production process and you can now go into your next project with some confidence.
If you would like to know more about the services we offer or how video can help your business please don’t hesitate to give Will or Andy a call on 01273 911345 or email us.