Clot Busters
Natural ways to keep blood vessels clear
One of the primary causes of heart attacks and strokes, atherosclerosis, is the hardening of artery walls due to a buildup of plaque. Normally your arteries are very flexible, like a rubber tube, but plaque causes them to become stiff, and can even block blood flow. Plaque can also lead to the formation of blood clots—thickened clumps of blood that form when blood platelets collect at the site of blood vessel damage.
If a piece of the clot breaks off, it will eventually circulate into a vessel that’s too small to allow it to pass. As a result, blood flow to that part of the body stops, and nearby organs or tissue can die. The bigger the clot, the bigger—and more important—the vessel it can block. If it blocks a blood vessel in the heart, it leads to a heart attack (also called a myocardial infarction). If it happens in the brain, it can cause a stroke. And if it happens in the lungs, it causes a pulmonary embolism. Anyone of these events can result in death.
The Importance of Good Fats
Excessive platelet aggregation is part of the process of atherosclerosis, and is an independent risk factor for heart disease and stroke all its own. Once platelets aggregate, they release potent compounds that promote the formation of plaque—or they can form a clot.
The “stickiness” of your platelets is largely determined by the types of fats in your diet and the amount of antioxidants you consume. While saturated fats and cholesterol increase platelet aggregation, omega-3s and monounsaturated fats have the opposite effect. Particularly useful for decreasing platelet aggregation are the long-chain omega-3 fatty acids EPA and DHA, found in fish oil. In fact, the beneficial effects of fish oils on platelet aggregation is one of the key reasons why higher levels of EPA and DHA in the diet are associated with a 50 percent reduced risk of stroke and heart attack.
For health maintenance, try a fish oil supplement that provides a daily dose of 1,000 mg combined of EPA and DHA. If you already have cardiovascular disease, elevated CRP levels, or high triglyceride levels, the recommended dosage is 3,000 mg daily.
Other Helpful Supplements
In addition to omega-3 fatty acids, there are a number of supplements that impact platelet aggregation. Most notable are antioxidant nutrients; flavonoids and other polyphenols; enzymes such as nattokinase; garlic; and vitamin B6.
Vitamin B6 may be particularly important. In one study, scientists measured the effect of B6 supplementation on platelet aggregation and cholesterol levels in 24 healthy men. Subjects were given either 5 mg of vitamin B6 per kilogram of body weight or a placebo every day for four weeks. Results showed that B6 inhibited platelet aggregation by 41–48 percent, compared to placebo. Vitamin B6 was also shown to significantly lower total cholesterol levels after four weeks.
Garlic preparations standardized for alliin content can also inhibit platelet aggregation. In one study, 120 patients with increased platelet aggregation were given either 900 mg per day of a dried garlic preparation or a placebo. In the garlic group, spontaneous platelet aggregation completely disappeared after four weeks, and other measures also improved.
Flavonoid-rich Extracts: The flavonoids in red wine are likely the reason French people are able to eat more saturated fat than Americans while maintaining a lower incidence of heart disease. A similar link has been found with flavonoids from chocolate, green tea, and other foods.
These flavonoids benefit the heart and blood vessels in many ways, including their ability to prevent excessive platelet aggregation. To make sure you’re getting enough of these flavonoid compounds, try at least one of the following supplements:
- Grape seed extract (>95 percent procyanidolic oligomers): 100–150 mg daily.
- Pine bark extract such as Pycnogenol(>90 percent procyanidolic oligomers): 100–150 mg daily.
- Any flavonoid-rich extract with a similar flavonoid content, a “super greens” formula, or another plant-based antioxidant with an ORAC score of at least 3,000 per day.
The Importance of Diet
One of the most popular recommendations for preventing excessive platelet aggregation is taking low-dose aspirin (80–325 mg per day). While this therapy has been shown to be effective in preventing a first heart attack, it’s not as powerful as making dietary changes. Several studies have shown that dietary modifications are not only more effective in preventing a recurrent heart attack than aspirin, but they can also reverse the blockage of clogged arteries.
The research on diets for heart disease prevention is strongest for the Mediterranean diet and a diet rich in both plant and fish sources of omega-3 fatty acids.
Fibrin and Nattokinase
Platelets are held in plaque by stringy protein strands called fibrin, which is made from smaller particles called fibrinogen. Elevated blood levels of fibrinogen are a major determinate of cardiovascular death. In fact, there is a stronger association between cardiovascular deaths and fibrinogen levels than there is for cholesterol. Natural therapies that help break down fibrin include the Mediterranean diet, exercise, omega-3 fatty acids, niacin, garlic, and nattokinase.
If you’re not familiar with nattokinase, it’s a clot-busting enzyme derived from natto—a Japanese food prepared from fermented soybeans. Nattokinase is known to:
- Dissolve excess fibrin in blood vessels, which improves circulation, breaks down clots, and reduces risk of severe clotting.
- Reduce LDL (bad) cholesterol and increase HDL (good) cholesterol.
- Reduce blood viscosity, improve blood flow, and lower blood pressure.
Clinical studies have affirmed the ability of nattokinase to reduce fibrinogen levels in the blood. Since elevated fibrinogen is a clear risk factor for heart attack or stroke, these results are extremely significant. Two capsules of nattokinase (100 mg or 2,000 fibrinolysis units per capsule) taken daily for two months may decrease fibrinogen levels by 7–10 percent.
Nattokinase should be used with caution if you take Coumadin or anti-platelet drugs (including aspirin, but especially prescription drugs such as Plavix or Ticlid), as it may increase bleeding tendencies.