The long-awaited law "not only accelerates the development of renewable energy with a new, attractive process for investors", the minister says, but also promises to drastically reduce the length of time it takes to complete the licensing process.
The industry largely welcomed the new law and is appreciative of Birbili's efforts to push it through despite Greece's economic woes. Nevertheless, there were a few unwelcome surprises, particularly the provisions for offshore wind. A number of grey areas also remain to be resolved. A lot depends on the decrees that will now follow, fleshing out the measures in more detail.
As expected, the new law, passed in May, set binding targets of 20% of final energy consumption and 40% of electricity to come from renewables by 2020. If adhered to, this will enable Greece to meet its European commitment to source 18% of its energy from renewables by that date.
To help get there, licensing has been simplified and reorganised so that the whole process should now take less than ten months, according to Birbili. This compares to up to five years under the old regime.
The most important changes concern the production licence, the first stage in the consenting process. This will now be issued by the national regulatory authority, RAE, rather than the energy ministry. RAE must give its decision within two months. In addition, the preliminary environmental impact assessment (EIA) will no longer be required. Instead, just one EIA will need to be completed prior to applying for the installation licence. The authorities have four months in which to give their decision on the EIA.
Under the new system, developers can apply for clearance from the forestry commission and for a grid connection, and sign a power purchase agreement before the EIA is completed. However, none of the agreements come into effect until after the installation licence has been issued.
While few developers believe consent will be given within the ten-month target, everyone is hoping it will be a lot quicker. "We expect the law will speed up the process and that more projects will be finalised," says Emmanuel Maragoudakis, managing director of Greek developer-operator Terna Energy.
The new law also introduces higher tariffs to spur investment. The guaranteed purchase price for plants on islands not connected to the grid is now EUR99.44/MWh and EUR87.84/MWh elsewhere, up from EUR91.74/MWh and EUR80.14 previously, for a 20-year term.
In addition, the new rates will be 20% higher if investors opt not to take any state subsidy. Up to now, developers could apply for subsidies amounting to around 30% of capital expenditure. "The system is more rational now," asserts Ioannis Tsipouridis, president of the Hellenic Wind Energy Association (HWEA). "It favours long-term operation of a project - not just build it, get the subsidy and get out."
Furthermore, the energy minister can grant higher tariffs for low-wind-speed sites. This is important because these areas tend to have good grid coverage, unlike high-wind-speed sites, explains Vassilis Spiliotopoulos, general manager of Gamesa Energia in Greece, a division of Spanish turbine manufacturer Gamesa. "Greece can't fulfill its targets just by developing high-wind areas," he adds.
The new law also stipulates that if a plant is built on an island which is not connected to the grid, and the grid is then extended to the island, the owner retains the higher rate. And if the owner pays for the new connection, they will get up to 25% extra, depending on the installed capacity and the length of the interconnection, among other things.
Planning problems
The industry is less happy about the ongoing problems caused by the spatial planning framework for renewables introduced in 2008 (Windpower Monthly, March 2009). While the new law irons out some inconsistencies, developers fear that it could lead to a dramatic increase in the extent of the protected areas where renewable energy projects are banned.
According to Gamesa, up to 20% of the Greek land mass could be included in the "exclusion zones" if the opposition puts pressure on the authorities. "It may result in a very dangerous situation whereby large areas of Greece are out of bounds," says Spiliotopoulos. However, the issue may be resolved in a new biodiversity law currently being drafted, or in the revised spatial planning framework, which could be out later this year.
One of the law's more innovative measures channels some of the revenues from wind plants to local residents to encourage greater acceptance of renewables. Under the old system, 3% of revenues went to the local authorities to fund development projects. Now 1% will go directly to local residents as a credit on their electricity bills, 0.3% to a green fund to support Natura 2000 nature reserves, and the local authoritities will get the rest. Electricity consumption in some households is so low they may get their electricity free, Tsipiroudis points out.
Achilleas Plitharas, campaigns officer of conservation group WWF, is not alone in thinking the new law is simply tinkering at the edges. "There are so many fundamental problems with the planning procedures in Greece that the law can't solve them," he states, pointing out that Greece still has no reliable data about the exact extent of its forest reserve, which affects the siting of wind turbines. "We still haven't got the fundamental instruments for environmental and renewables policy," Plitharas adds.
The industry was rather taken aback by the sudden change in policy for offshore wind. The guaranteed purchase price for offshore has been replaced with a tender system. The state will identify areas suitable for development and then call for bids. But George Athanasiou of Athens-based RF Energy fears the tender process will delay things. The authorities will have to carry out long, complicated studies to define the areas, assess their capacity and consider the options for grid connection.
Of more immediate concern is what will happen to those offshore projects already in the construction permitting system. According to Maragoudakis, RAE will evaluate them under a fast-track system. Those that are approved will be given some sort of certificate to be taken into account during the tender.
Before commenting please read our rules for commenting on articles.