Model Analysis of Plane Structures
1st Edition
The Commonwealth and International Library: Structures and Solid Body Mechanics Division
Description
Model Analysis of Plane Structures deals with simple techniques of analysis plane structures with the aid of scale models. Model analysis of the kind considered herein is a means of replacing the numerical work of formal structural analysis by mechanical operations. It utilizes the same assumptions as formal analysis and offers nothing more in the end-product, but the user gains unique insight into structural behavior. The book begins with a discussion of early approaches to systematic model analysis and the limitations and accuracy of model analysis. This is followed by separate chapters on the approach to flexural similarity, which consists essentially of determining directly the conditions for the properties of deformation of two geometrically similar structures to be similar; the theory of indirect model analysis; and models of frame networks. The final two chapters deal with the use of models for indirect analysis and direct analysis, respectively; these conclude with sample problems to enable readers to test their understanding of the subject matter.
Table of Contents
Preface
1. Introduction to Model Analysis
Early Approaches to Systematic Model Analysis
Beggs's Apparatus
Gottschalk's Apparatus - "The Continostat"
Rieckhof's Apparatus - "The Nupubest"
Limitations and Accuracy of Model Analysis
2. Similarity of Structures
General Expression for the Deflection of a Structure
Conditions for Flexural Similarity
Theory of Dimensions and Similarity
Dimensional Analysis of Beam Flexure: Flexural Similarity
Relationships Between Model and Prototype Quantities
3. Theory of Model Analysis
Influence Lines for Forces: Müller-Breslau's Principle
Justification of Müller-Breslau's Principle
The Reciprocal Theorem and Müller-Breslau's Principle
Betti's Theorem
Müller-Breslau's Principle by the Concept of Flexibility Coefficients
Müller-Breslau's Principle by Direct Application of Betti's Theorem
Influence Lines for Deflection
Members in Bending and Treatment of Loading in Relation to Model Analysis
Slope-Deflection Relationships
Treatment of Loads on Beams in Structures
4. Models of Plane Frameworks
Nature of Models
General Design of Models
Design of Models of Portal Frames
Design of Models of Trusses
Model Materials
Xylonite-celluloid, Bakelite and Perspex
Metal
Cardboard
Manufacture of Models
Mounting of Models
Introduction of Displacements at Supports
Introduction of Internal Displacements
Design of Internal Joints and Flexible Elements
Typical Models of Rigidly Jointed Frameworks
Power Station Building Frame
Vierendeel Girder
5. Use of Models for Indirect Analysis
Influence Lines for Reactions
Internal Forces and Moments
Treatment of Distributed Loads
The Large Displacement Technique
Checking of Model Results
Examples of Calculations Relating to Model Tests
Problems
6. Use of Models for Direct Analysis
Interpretation of Compensating Balance Readings—The Concept of the "Prototype Balance"
Influence Lines for Deflection
The Moment Indicator for Portal Frames
Interpretation of Moment Indicator Results for the Prototype
The Moment Deformeter
Coker's Method for Direct Measurement of Model Strains
Problems
Appendix I
Bibliography
Appendix II
The Principle of Virtual Work Applied to Frameworks
Appendix III
Verification of Analysis of Portal Frameworks
Details
- No. of pages:
- 122
- Language:
- © Pergamon 1966
- Published:
- 1st January 1966
- Imprint:
- Pergamon
- eBook ISBN:
- 9781483138114