Suppliers believe demand for all-wheel-drive systems will be stronger than ever once the current recession ends.
Until then, they’ll remain hard at work developing new, advanced systems that are more cost-effective and fuel-efficient, executives say.
While it has been impacted by the severe market downturn, Swedish supplier Haldex AB says it has weathered the storm better than some competitors due to the recent introduction of its new fourth-generation AWD technology.
The new system, which Haldex says is more cost-effective, lighter and faster responding because it uses fewer parts, debuted on Volkswagen AG’s Tiguan small cross/utility vehicle. Since then, other VW Group models have migrated to the technology, including the VW Golf, Passat, Caddy and Multivan; Audi TT and A3; and Skoda Octavia, Superb and Yeti.
“We have been fortunate launching new models (during the recession),” says Ulf Herlin, vice president-business development for Haldex Traction Systems Div. “So at least it dampens the fall for us compared to many suppliers.”
Other parts makers say the economic downturn has caused a change in the type of systems cost-conscious consumers are demanding.
While many car buyers value the benefits of AWD, such as increased safety, they are concerned about the added cost and negative effect the technology has on fuel economy, says Ericka Nielsen, director-marketing for BorgWarner Inc.
“Customers are always making decisions, and fuel economy plays into that,” she says. “One way to (address that concern) is to reduce the penalty for AWD (systems) by making them more compact, active, integrated and fuel-efficient.”
BorgWarner is delving further into development of electronically controlled, on-demand AWD systems that can be tailored to specific vehicle sizes.
“We’re seeing a trend with our OEM customers who are trying to right-size their AWD systems to match drivers’ mobility requirements,” says John Barlage, BorgWarner product business director.
Erwin Haas, senior vice president and head of engineering-Magna Powertrain, agrees the AWD market is shifting due to demand for greater fuel economy. That has the Canada-based supplier concentrating much of its efforts on developing AWD systems for smaller vehicles.
“In this market, people are buying smaller cars,” he says. “For sure, fuel consumption is a big task for the future, and all customers are asking for cost reductions besides the environmental issues we have to address.”
In the U.S., AWD traditionally has been more widely available on imports than domestic models.
For the ’04 model year, 8.7% of imported cars featured the systems, compared with just 1.4% of domestic cars, while imported light trucks boasted a 65.4% penetration rate vs. 49.3% of domestics, Ward’s data shows.
That gap has not narrowed much in the last four years. In ’08, only 2.6% of domestic cars featured the system, compared with 11.3% of imported cars. The ’08 light-truck AWD penetration rate for imports was a whopping 63.8%, vs. 48.6% for the domestics.
But the gap may be on the verge of narrowing, as both Magna and Haldex expect U.S. demand to rise.
Herlin says much of the anticipated growth will come from U.S. consumers who continue to exit the truck segment in favor of CUVs.
“I see more CUVs taking over truck-based vehicles,” he says. “When customers who are used to having a truck buy a CUV for the first time, they want (AWD systems).”
Haas notes the U.S. penetration rate was at an all-time high before the recession.
“We know the market is down in the U.S., but in Europe (we’re) facing some problems because volume is shrinking there and customers are delaying or cancelling programs.”
Europeans and Americans also demand different AWD attributes, Herlin says.
“In Europe, everybody reads (automotive) magazines, so a vehicle evaluation is important for a buyer,” he says. “In the U.S. it’s more cost-oriented. Period.”
While suppliers wait for an upturn in the U.S. and monitor the situation in Europe, they largely remain bullish on emerging markets. In places such as China, Russia and India, “requirements are not as high as Europe and North America,” Haas says.
Some emerging markets, particularly China, appear on track to surpass developed nations in automotive technologies, Herlin says, adding Haldex does not yet supply Chinese auto makers with AWD.
“If you looked at Japan when they first started building cars, they weren’t very good. Now we all know how good they are,” he says. “Korea was the same way. I think China will go the same way, but even faster. They have the skill and means to learn faster.”
Ironically, the growth in AWD demand could negatively impact some suppliers, as auto makers begin to see the value in bringing that work in-house.
“So in this type of market, you have to evaluate when to participate in programs,” Nielsen says.
To sustain future growth, suppliers are looking for new ways to integrate AWD technology with advanced powertrains, particularly electric.
BorgWarner got a jump on the trend when it won the contract to supply the AWD system for Tesla Motors Inc.’s Roadster electric vehicle.
“The roadster is very specialized and small volume, but it was good to be aligned with such a high-profile vehicle,” Barlage says, noting developing an AWD system that could handle the high-torque capacity of the car’s electric drivetrain proved challenging.
“Lessons learned on that will be applied to more practical, higher-volume vehicles,” he says. “But I’m excited about the future of electrification and the opportunity it holds.”
Magna will supply the drivetrain, among other components, for the planned Ford Focus EV due next year.
“We’re going to support the electric Focus, and in Europe (we have) a lot of activities regarding electrification, including full EVs, or electric axles for hybrids,” Haas says.
Meanwhile, Haldex is working on upgrading its current AWD portfolio, including the development of low-cost, torque-vectoring AWD technology that can direct power to individual wheels.
While a handful of luxury auto makers currently offer such systems, cost has prevented application on high-volume vehicles.
“We have prototypes, but they’re not in production with any car manufacturer,” Herlin says. “We’re working on different concepts and trying to get a cost-effective system that would interest our customers.”