Perhaps you have seen single LED light sources or multiple LED clusters on our website and the package (cup, grommet or bullet style housing) simply doesn't suit your purposes. You have a bit of technical savvy or a friend to help you, and want to create your own product, customized to fit your particular needs. Here is the information you will need to do exactly that. You will need:
1. The data sheet for the particular LED you will be using. Here is a link to a sample data sheet. Once you've selected the particular LED you want to use, be sure to have it's particular data sheet handy when you begin to work.
2. Our resistance calculator. Once you determine which resistor to use, you'll find that these are readily available at your local electronics store. We do not stock resistors as there are too many variations to make that practical.
3. The information below. Here is a link to an easy to print .pdf file.
Most LEDs have their characteristics specified at a current of 20 mA. If you want really good reliability and you are not certain you don't have worse-than-average heat conductivity in your mounting, heat buildup in wherever you mount them, voltage/current variations, etc. then design for 15 milliamps.
Now for how to make 15 milliamps flow through the LED:
First you need to know the LED voltage drop. It is safe enough to assume 1.7 volts for non-high-brightness red, 1.9 volts for high-brightness, high-efficiency and low-current red, and 2 volts for orange and yellow, and 2.1 volts for green. Assume 3.4 volts for bright white, bright non-yellowish green, and most blue types. Assume 4.6 volts for 430 nM bright blue types such as Everbright and Radio Shack. Design for 12 milliamps for the 3.4 volt types and 10 milliamps for the 430 NM blue.
You can design for higher current if you are adventurous or you know you will have a good lack of heat buildup. In such a case, design for 25 ma for the types with voltage near 2 volts, 18 ma for the 3.4 volt types, and 15 ma for the 430 NM blue.
Meet or exceed the maximum rated current of the LED only under favorable conditions of lack of heat buildup. Some LED current ratings assume some really favorable test conditions - such as being surrounded by air no warmer than 25 degrees Celsius and some decent thermal conduction from where the leads are mounted. Running the LED at specified laboratory conditions used for maximum current rating will make it lose half its light output after rated life expectancy (20,000 to 100,000 hours) - optimistically! You can use somewhat higher currents if you heat-sink the leads and/or can tolerate much shorter life expectancy.
Next, know your supply voltage. It should be well above the LED voltage for reliable, stable LED operation. Use at least 3 volts for the lower voltage types, 4.5 volts for the 3.4 volt types, and 6 volts for the 430 NM blue.
The voltage in most cars is 14 volts while the alternator is successfully charging the battery. A well-charged 12 volt lead-acid battery is 12.6 volts with a light load discharging it. Many "wall wart" DC power supplies provide much higher voltage than specified if the load is light, so you need to measure them under a light load that draws maybe 10-20 milliamps.
Next step is to subtract the LED voltage from the supply voltage. This gives you the voltage that must be dropped by the dropping resistor. Example: 3.4 volt LED with a 6 volt supply voltage. Subtracting these gives 2.6 volts to be dropped by the dropping resistor.
The next step is to divide the dropped voltage by the LED current to get the value of the dropping resistor. If you divide volts by amps, you get the resistor value in ohms. If you divide volts by milliamps, you get the resistor value in kilo-ohms or k.
Example: 6 volt supply, 3.4 volt LED, 12 milliamps. Divide 2.6 by .012. This gives 217 ohms. The nearest standard resistor value is 220 ohms.
If you want to operate the 3.4 volt LED from a 6 volt power supply at the LED's "typical" current of 20 ma, then 2.6 divided by .02 yields a resistor value of 130 ohms. The next higher popular standard value is 150 ohms.
If you want to run a typical 3.4 volt LED from a 6 volt supply at its maximum rated current of 30 ma, then divide 2.6 by .03. This indicates 87 ohms. The next higher popular standard resistor value is 100 ohms. Please beware that I consider the 30 ma rating for 3.4-3.5 volt LEDs to be optimistic.
One more thing to do is to check the resistor wattage. Multiply the dropped voltage by the LED current to get the wattage being dissipated in the resistor. Example: 2.6 volts times .03 amp (30 milliamps) is .078 watt. For good reliability, I recommend not exceeding 60 percent of the wattage rating of the resistor. A 1/4 watt resistor can easily handle .078 watt. In case you need a more powerful resistor, there are 1/2 watt resistors widely available in the popular values.
You can put LEDs in series with only one resistor for the whole series string. Add up the voltages of all the LEDs in the series string. This should not exceed 80 percent of the supply voltage if you want good stability and predictable current consumption. The dropped voltage will then be the supply voltage minus the total voltage of the LEDs in the series string.
Do not put LEDs in parallel with each other. Although this usually works, it is not reliable. LEDs become more conductive as they warm up, which may lead to unstable current distribution through paralleled LEDs. LEDs in parallel need their own individual dropping resistors. Series strings can be paralleled if each string has its own dropping resistor.
Copyright: Don Klipstein, Jr. 01/01/00 - Mr. Klipstein is not employed by The LED Light.