As a small business owner, chances are that the safety and security of your pharmacy’s patients and employees are among your top priorities.
When you have open positions to fill, it’s easy to rely on resumes and ‘gut instinct’ to make quick hiring decisions. But not so fast! It’s important to implement a robust employee screening program to help mitigate your security risk and protect your pharmacy, your patients and your staff.
Why screen prospective and current employees?
By properly screening of job applicants and employees, you can:
- Help ensure that your pharmacy staff is of the best possible quality;
- Minimize the risk of employing personnel with a propensity for criminal activity or substance abuse;
- Reduce the risk of that you’ll employ someone under federal government sanctions—which could put at risk your ability to accept, or receive payment for, Medicare-related business.
What’s included in an employee screening?
The above-listed risks can be minimized by following a two-step employee screening process, consisting of (1) a criminal background check and (2) a drug test.
Background checks are governed by the Fair Credit Reporting Act (FCRA) which, among other things, regulates Credit Reporting Agencies (CRAs). You can conduct a criminal background check by working with a credit reporting agency—a good one can help you navigate the intricacies of the Fair Credit Reporting Act.
Employee screening can be divided into pre-employment, and post-hire. What follows are some steps you can take to help you hire, and maintain, better employees.
Pre-employment screening
There’s no need to screen every job applicant—only screen applicants after you extend an offer of employment. Actual hiring should be contingent upon successful completion of the screen.
For the criminal background check, consider having your credit reporting agency perform the following checks. Although it’s possible to select only a few items from this list, we generally recommend ordering the most comprehensive search possible. This approach will provide you with the most protection and peace of mind:
- Criminal Felony and Misdemeanor Check
- Education Report
- Employment Verification Check
- Federal Criminal Check
- Healthcare Sanctions Check
- National Criminal Database Search
- SSN Trace and validation
Applicants for positions requiring driving a motor vehicle should also undergo a Motor Vehicle Record (MVR) check. Again, your credit reporting agency will be able to perform this check for you.
For the drug test, Cardinal Health recommends our retail pharmacy customers use a hair drug test. Although a bit more expensive than urine tests, hair tests are extremely difficult to defeat, and are thus more effective in helping to ensure your applicants are drug-free. However, hair drug tests are not permitted in Hawaii, Iowa, and Puerto Rico; if you are in one of these states, require a urine drug test instead.
Post-hire screening
Consider performing periodic criminal background checks (every two years is a reasonable interval) on all of your employees. This will ensure that you always have more current information, avoiding reliance on criminal background checks that are several years old.
It’s generally a best practice to perform random drug tests on all of your employees, state law permitting. Requiring these at least every six months, especially with hair tests, will serve as a deterrent against illegal drug use, lets your employees know that you will not tolerate illegal drug use and will help minimize employees’ temptation to divert controlled substances.
Decide in advance what the consequences of a positive drug test will be. Will you terminate the employee or will you give him or her a second chance? If a second chance, will you ask the employee to seek professional counseling for a substance abuse problem?
Also, become familiar with procedures for reasonable suspicion substance testing. Reasonable suspicion refers to circumstances where a business owner suspects an employee is impaired, and would require him or her to submit to a drug and/or alcohol test.
Finally, if you suspect one of your employees of alcohol-induced impairment, be prepared to require a Breath Alcohol Test (BAT, also known as breathalyzer). Because the human body metabolizes alcohol quickly, don’t wait until such a situation arises to decide how you will handle it, and where and how you will send the employee for a breath alcohol test.
Follow these best practices before you hire new employees to join your pharmacy team, and make sure your employees know that you’ll continue to perform these screenings to protect the safety of your pharmacy, your patients and your employees. Taking these precautionary steps can help mitigate security risks and give you the peace of mind of knowing that your pharmacy is staffed by employees you—and your patients—can trust.
*The information provided should be considered as precautionary, and does not warrant or represent that by implementing such measures, your business will be free from any and all security risk or damages.