Rivers need water to exist. Notwithstanding this obvious fact, it was difficult to view the teeming rain in a positive light. We struggled under our overweight packs, stuffed with rafting gear, 12 days of food and approaching 40 kilograms each, slipping and tripping in the mud and sodden vegetation of the overgrown Jane River Track. We were sometimes reduced to crawling under fallen trees. This continued for well into our second day, until the first glimmers of sunshine appeared soon after we reached the banks of Erebus Rivulet. Resting among the steaming vegetation, we were pleased to note the strong flow and good water level in the stream that was our planned access to the Jane River, despite its reputation for log jams.
The Jane River is the major tributary of Tasmania’s famous Franklin River. It rises about 12 kilometres south of the distinctive white dome of Frenchmans Cap and winds through wild and remote forest and gorge country. The river initially meanders through low, scrubby terrain across Lightning Plains, but becomes readily navigable by small raft below its confluence with the Erebus Rivulet, and this latter stream provides the best access to the Jane. In the subsequent 30-kilometre journey to the Franklin River it falls some 250 metres and passes through three lengthy and spectacular gorges. Here, portages are necessary and river levels are a major consideration for travellers.
While the Franklin River can be accessed directly from the Lyell Highway, the Jane requires a 23-kilometre slog down the remnants of an old mining access track, closed over 25 years ago. Alluvial gold was found at Reward Creek (south of the Erebus) in 1935 and mined on a small scale over the subsequent 20 years. The Jane River Track, including bridges of sorts over several major streams, was constructed in the late 1930s as a packing route to the goldfield. There was renewed active interest in the gold prospect by Hobart mining syndicates during the 1970s and 80s, which included upgrading of the track and the use of tractors and an excavator. Little gold was extracted and the mining operation was finally closed down after the area was included in an expanded Tasmanian Wilderness World Heritage Area in 1989.
The Jane River Track has become increasingly overgrown ever since. This has resulted in a welcome increase in the remoteness of this wild country. On the Jane River itself, there is virtually no evidence of human activity, as has been the case for thousands of years.
The first recreational descent of the Jane River was by li-lo in 1976. Trips are still rare and the river remains very remote and challenging with little evidence along its banks of those who have gone before.
There were plenty of blue gaps between the clouds as we set off down the Erebus Rivulet, and this turned out to be the start of a week of fine dry weather, making our trip both generally pleasant and perhaps more carefree than those who face rising river levels when tackling the Jane. With our first tentative paddle strokes we gained a feel for the stability of our small packrafts with a heavy load strapped onto the bow. Being on the water also provided assurance that we were really here, that the planning and access trials were over, and the challenges ahead would likely be of a different nature.
The Erebus Rivulet meandered through lush rainforest, still dripping from yesterday’s rain, with the occasional shingle rapid and, despite the relatively high water level, many logs. Sometimes merely jumping out was enough to float the raft over an obstacle before re-entering and continuing on, all the time trying to keep the raft oriented to slide through gaps between logs and shingle banks. A technique evolved for crossing larger mid-stream logs whereby we would drift up to the log, clamber onto it, drag the laden raft’s bow onto the log’s crest and then quickly swivel the stern over and into the river downstream, before leaping in and continuing on. This was often awkward, balancing on a slippery log while hauling a heavy weight in a far from ergonomic position, but thankfully no injuries were reported.
Our first river camp was on a mid-stream shingle bank not far down the Jane River, with a downstream view of hills closing in and the bulk of River Peak North beyond; the river was entering the gorge country. During next morning, the river’s bends became progressively tighter, the ridges steeper, and the sliver of sky seen above narrower as we entered the long Enkidu Gorge.
The Jane River’s three major gorges have been named Enkidu, Gilgamesh and Humbaba. These unusual names are characters in an epic poem from ancient Mesopotamia, written some 4,000 years ago, the moral of which is, ‘life which you look for, you will never find’. This is perhaps an appropriate message to reflect on as one journeys down a river like the Jane…
…The journey continues in Wild issue 157. Subscribe today to receive your copy.