Calls for Early Negotiated Settlements to Water Flashpoints
A new study conducted by the California-based Pacific Institute has called for negotiations to mitigate the potential for new challenges such as climate change to exacerbate tensions between countries where rivers and aquifers are shared.
The work “Understanding and Reducing the Risks of Climate Change for Transboundary Waters,” was conducted in association with the United Nations Environment Program (UNEP) and found there was increased pressure on shared water resources through population growth and heightened average temperatures through global warming.
The increased tension had the potential to lead to future cross border conflicts between neighboring countries over shared trans boundary water basins including rivers and aquifers, the research concluded.
The report says that, although much of the historical water disputes between riparian states have been resolved diplomatically, with an estimated 300 treaties agreed between states, the challenge of increasing demand for lessening water supplies could lead to armed conflict where waterways and aquifers cross boundaries.
“Future pressures, such as population and economic growth and climate change, could increase tensions, even in areas that in the past have been characterized by cooperation,” said the report.
It added that changes to the way a country manages its water resources in future years will be challenging enough under climate change but considered this to be more so where resources are shared with a neighboring country.
“Global climate change will pose a wide series of challenges for freshwater management as a result of changes in water quantity,,” the authors said.
The study maintained that states should prepare for such change in order that future conflict over riparian resources may be averted concluding that, while shared resources can act as a possible flashpoint for control, a better solution was that rival countries use diplomatic means to end disputes.
“Shared waters can be a source of conflict, but they can also be a source of cooperation and negotiation,” the authors concluded. “Future pressures, such as population and economic growth and climate change, could increase tensions, even in areas that in the past have been characterized by cooperation. Yet, shared challenges may also be a platform for developing new institutional arrangements to plan for the future.”
However Heather Cooley, a senior research associate with the Pacific Institute and one of the report’s authors, told water news portal Circle of Blue in an interview published on January 14 that water experts had seen little sign of global Governments preparing for new water challenges by negotiating or renegotiating water agreements.
She said this was despite scientists warning for decades that the water supply crisis will aggravate water tensions with neighbors, even where riparian treaties had already been negotiated.
“There have been some efforts to try to evaluate the impacts of climate change, look at shortage requirements within these agreements … but nowhere near what needs to be done to address these risks,” Cooley told Circle of Blue.
She added that it was far better for states to cooperate and coordinate their trans-border activities and to work out their supply differences before a more dangerous dispute does occur.
“This could be used as an impetus for even greater cooperation and the development of adaptation strategies,” she said. “With different countries operating dams and reservoirs along these waterways, it’s very important that they coordinate their efforts. … As we point out, it’s best to try to do that before there’s an issue.”
The report concluded that riparian water tensions between neighboring states could best be avoided by adopting the following measures:
- The establishment of treaties covering water resources which cover trans boundary water basins, currently relatively rare in international agreements.
- The bringing into force of the United Nations’ Convention on the Law of the non-Navigational Uses of International Watercourses to provide an international framework for discussions. The convention was adopted by the UN General Assembly in 1997 but is yet to be brought into force.
- Use existing water agreements as a basis to expand agreement.
- Assess and amend if necessary existing agreements if they prove to be outdated.
- Establish joint water resources monitoring programs.
- Conduct climate change assessments to assess vulnerability of water resources.
Previously published by OOSKAnews.
- January 30, 2010 at 12:58 amTweets that mention Calls for Early Negotiated Settlements to Water Flashpoints « The Scribbler's Elbow -- Topsy.com