According to Adobe, 59% of global consumers would rather engage with content that’s beautifully designed as opposed to simply designed. Additionally, they reported that nearly 9 out of 10 mobile users would switch devices or stop viewing content altogether if it fails to meet their quality, length, and formatting expectations.
Needless to say, if you are a web designer, you have a lot on your plate. After years of both professional and self-taught training, clients depend on you to meet their vision and ensure that their customers will appeal to the overall design, responsiveness, and functionality of your design. If not, you will face excessive revisions — or worse, lose a client.
Handling Client Feedback
You spend months working on a website, agonizing over every detail. You anticipate the deadline, so assured and confident that the client will love the final mockup. You form a grin, click “send,” and wait for the accolades to start pouring in.
Then you get an email that says, “I don’t like this direction.” or “This is not what I had in mind.”
No matter how long you’ve been in the web design industry, one of the most daunting feelings is handling client feedback. In situations where a client seeks revisions, you must tread lightly because showing any signs of aggravation would risk losing the project.
The best way to go about web design revisions is to establish a system. This system can be integral to your success, and without it, you might waste countless hours performing changes.
1. It starts with getting to know your client before starting the web design process.
When you get a client whose budget is over the moon, it’s easy to get caught up in the moment and start making unwise decisions. As a web designer, you must understand the needs, wants, and goals of a client to avoid revision requests altogether.
The goal is to get inside your client’s head at the very beginning of the project to come across fewer problems later in the process. Take the time to thoroughly discuss not only the client’s vision for the website but also the functionality it needs. This will ultimately limit or eliminate the need for extensive revisions.
For instance, if you agreed to a five-page site and realized towards the end of the project that one of those pages should function as a blog with its own comment section, search bar, and category archive sub-pages — you will have a major revision problem in your hands. Always remember to be unassuming when it comes to what the client wants. Ask questions and have the right conversations before you start designing to help you avoid these types of unnecessary surprises and revisions.
2. Seal the deal by signing a contract.
After discussing the ins and outs of the web design project, you need to put all of it in writing. A contract should elaborate the scope of the project, the costs, and how you will handle future revisions. Don’t hesitate to include a specific number of revisions with your quote, or opt to charge an hourly rate for any changes. Have your own policies as a professional web designer.
Detailing your revision policies in the contract will ultimately set parameters for the project and give you a point of reference, should the client begin making excessive requests.
3. Showcase your sense of honesty and diplomacy.
Revisions are part of any creative’s job, but you should also explain to a client that extra charges are inevitable when requests go beyond the scope of what they are paying you. For instance, when a client asks for more revisions, you can tell them that you’re happy to make the change and add it to the bill.
It’s also crucial to walk a client through the changes to help them understand why you need to add extra charges. Communication is a powerful tool for both conflict management and contract negotiation, among other things. Let’s say towards the end of the project, the client asks for unrealistic revisions. You can say, “No, that’s not possible because…,” which can come off extremely negative. It’s better to choose your words carefully and say, “Yes, we could definitely do that, and it’ll cost you this much extra because….” This way, you either extend the project and expand your earnings, or make it crystal clear that their request is unfeasible — but in a positive light.
A Word of Advice
Once you incorporate these best practices into your client discovery and web design process, the project should be smooth sailing. But don’t expect the same results for every client and project — that’s just the reality of it. Remember, the best thing you can do during the initial phase is to discuss and define each goal thoroughly. Before you embark on a new web design project, it’s imperative that both you and your prospective client are on the same page.
Additionally, it wouldn’t hurt to be selective. When choosing to work with a client, try to look for characteristics that serve as hints on how well your working relationship will be. You should examine the following:
- How passionate are they about the project?
- Are they haggling before you even begin to bounce ideas?
- Do they have a clear picture of their own goals?
- Are they willing to take your professional advice?
- Are they showing an interest in working with you specifically?
In general, if the client shows hesitation or a lack of understanding of their own project needs and goals, you should consider turning them down. After all, it’s your time and talent that’s on the line.
If you have further questions or are in need of professional web design services, let PrimeView employ effective solutions according to your business goals and needs. Call us today at 480-970-4688 or complete