Here's a letter from the Financial Times. I usually don't repeat letters on this blog since the point here is to find more authoritative voices who can look at high-speed rail in California and in the Nation with an informed, but untainted eye.
However, Mr. Gregg Spindler's letter, from Cazenovia, New York, is on to something. What actually caught my eye is 'Cazenovia', since I grew up near there, in Syracuse (yes, that Syracuse). Mr. Spindler has it quite right. Simply put, for the United States, high-speed rail is counter-indicated.
That is to say, for many of the reasons he offers, it's inappropriate and doomed to be unsuccessful in our country, and certainly in our state. This is a far less romantic vision of HSR, such as espoused by the promoters -- "build it and they will come."
While upgrading Amtrak is relatively harmless, insofar as that passenger service continues to use existing, freight operator-owned track, building over 150 mph train accommodations requires dedicated tracks within dedicated corridors. And that's hugely expensive. Such development is, not surprisingly, most expensive where the population is the most dense, and it's only there that that high-speed rail can draw upon a large enough population segment financially qualified to use such a train.
Spindler points out that New Jersey is more dense than a number of European countries. Yes, and so what? What's important is the overall density of the entire rail corridor running through a number of states (including New Jersey); in this case from Washington, D.C. to Boston. That's the Northeast Corridor and the region not only with the greatest population density over its entire 400 mile distance, but passing through several of the most important metropolitan areas in the US, starting with Washington, Philadelphia, New York and Boston. That's as close to "Europe" or "Japan" as we are going to get. The rest of this country, and California, don't meet that baseline.
Spindler is also correct that a major impediment to greater train speed for Amtrak is the fact that they run on what are essentially freight-owned freight rails. And it's freight train speeds that constrain passenger traffic. To "fix" all that in order to make passenger rail in the US recapture its former glory, demands stunning amounts of investment.
We need to be able to entertain rail transportation from the viewpoint of the profitable (genuinely profitable) freight operators, such as CSX, BNSF and the largest, Union Pacific. They gave up passenger rail but agreed to permit Amtrak's continued use of their rail corridors. As passenger demand diminished, so did the number of miles of usable rail. In effect, passenger rail as an industry, was market driven. When the market declined, the train operators responded accordingly, salvaging their profitable freight businesses and abandoning passenger service.
Meanwhile, freight rail in the US continues to be the world's best. How accommodating do we expect the freight carriers to be in order to indulge the HSR promoters their personal dreams of glory and wealth? The freight operators can read the same critical literature available to us. They know what's really going on.
Even if we acknowledge some benefits from such a comprehensive passenger rail system, the costs are staggering and therefore a bad investment. We should also point out that high-speed rail has no chance of success whatsoever without being "grounded" on top of an existing, comprehensive rail system with fully developed secondary connector transit services, including regional and commuter rail. Which we do not have.
When Spindler says "Barriers block US high-speed rail," I take that to mean institutional, demographic, economic and geographic barriers, not merely reluctance on the part of the population. What's much worse, however, is that the concerns about high-speed rail are nothing more than the political wolf in sheep's clothing.
Of all the not shovel-ready infrastructure projects that the DOT could have developed as a program, high-speed rail is the most flagrantly bad choice. Alternatively, they could have launched, just for example, a FIX AMERICA program, one so sorely needed, and one shovel ready right now. To abandon a vast, deteriorating infrastructure foundation in the US, and simultaneously seek a glittering, seductive trinket like HSR is a grossly immature judgement.
We all should, by now, have had a sufficient education in matters high-speed rail to be able to come to these same conclusions. And therefore require that this entire wishful fantasy be terminated.
====================================================
December 12, 2011 2:50 am
Barriers block US high-speed rail
From Mr Gregg Spindler.
Sir, Lex (“US high-speed rail”, December 7) incorrectly states that the US lacks the population density of Europe or Asia where high-speed rail exists or is being expanded. New Jersey is more densely populated than the UK or Germany, Florida more so than either France or Spain.
More
One major difference is the virtual lack of viable public transit systems that might serve as feeders for rail and suburban sprawl. The US has built a transport system wedded to the automobile and airlines.
Political will is the main barrier to HSR in the US. Neither political party has ever had a consistent commitment to rail transport, but both are enthusiastic at subsidising alternative modes. The Obama administration’s current programmes and proposals would be laughable if it was not actually serious about them.
Another impediment is that virtually all rail rights of way are owned by private rail companies which operate freight trains up to 2.5 miles in length, making operation of viable passenger service virtually impossible. Freight railroads even oppose separate passenger-only tracks on their rights of way.
Lastly, there is the question of funding. In a country where 17 per cent of GDP goes to healthcare and 10 per cent to “defence” and “security” spending, there is little funding to maintain existing highways and airports, much less to build new HSR. But unless the occupy movement realigns politics and gets special interest money out of politics, nothing close to sustainable economic or environmental policies will be adopted in the US.
Gregg Spindler, Cazenovia, NY
Copyright The Financial Times Limited 2011. You may share using our article tools.